/*
 * Decompiled with CFR 0.152.
 */
package exp.libs.db.redis;

import exp.libs.db.redis._IJedis;
import exp.libs.db.redis._Jedis;
import exp.libs.db.redis._JedisCluster;
import exp.libs.db.redis.bean.RedisBean;
import exp.libs.utils.str.StrUtils;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import redis.clients.jedis.HostAndPort;

public class RedisClient
implements _IJedis {
    public static final String DEFAULT_IP = "127.0.0.1";
    public static final int DEFAULT_PORT = 6379;
    private _IJedis iJedis;

    public RedisClient(RedisBean rb) {
        if (rb == null) {
            this.iJedis = new _Jedis(DEFAULT_IP, 6379);
        } else if (!rb.isCluster()) {
            HostAndPort hp = new HostAndPort(DEFAULT_IP, 6379);
            Iterator<String> sockets = rb.getSockets().iterator();
            if (sockets.hasNext()) {
                hp = RedisClient.toHostAndPort(sockets.next());
            }
            this.iJedis = new _Jedis(rb.toPoolConfig(), rb.getTimeout(), rb.getPassword(), hp.getHost(), hp.getPort());
        } else {
            LinkedList<HostAndPort> clusterNodes = new LinkedList<HostAndPort>();
            Set<String> sockets = rb.getSockets();
            for (String socket : sockets) {
                HostAndPort node = RedisClient.toHostAndPort(socket);
                if (node == null) continue;
                clusterNodes.add(node);
            }
            this.iJedis = new _JedisCluster(rb.toPoolConfig(), rb.getTimeout(), rb.getPassword(), RedisClient.toArray(clusterNodes));
        }
    }

    public RedisClient() {
        this(DEFAULT_IP, 6379);
    }

    public RedisClient(String ip, int port) {
        this.iJedis = new _Jedis(ip, port);
    }

    public RedisClient(String ip, int port, int timeout) {
        this.iJedis = new _Jedis(timeout, ip, port);
    }

    public RedisClient(String ip, int port, String password) {
        this.iJedis = new _Jedis(password, ip, port);
    }

    public RedisClient(String ip, int port, int timeout, String password) {
        this.iJedis = new _Jedis(timeout, password, ip, port);
    }

    public RedisClient(String ip, int port, int timeout, GenericObjectPoolConfig poolConfig) {
        this.iJedis = new _Jedis(poolConfig, timeout, ip, port);
    }

    public RedisClient(String ip, int port, String password, GenericObjectPoolConfig poolConfig) {
        this.iJedis = new _Jedis(poolConfig, password, ip, port);
    }

    public RedisClient(String ip, int port, int timeout, String password, GenericObjectPoolConfig poolConfig) {
        this.iJedis = new _Jedis(poolConfig, timeout, password, ip, port);
    }

    public RedisClient(HostAndPort ... clusterNodes) {
        this.iJedis = new _JedisCluster(RedisClient.removeDuplicate(clusterNodes));
    }

    public RedisClient(int timeout, HostAndPort ... clusterNodes) {
        this.iJedis = new _JedisCluster(timeout, RedisClient.removeDuplicate(clusterNodes));
    }

    public RedisClient(String password, HostAndPort ... clusterNodes) {
        this.iJedis = new _JedisCluster(password, RedisClient.removeDuplicate(clusterNodes));
    }

    public RedisClient(int timeout, String password, HostAndPort ... clusterNodes) {
        this.iJedis = new _JedisCluster(timeout, password, RedisClient.removeDuplicate(clusterNodes));
    }

    public RedisClient(GenericObjectPoolConfig poolConfig, int timeout, HostAndPort ... clusterNodes) {
        this.iJedis = new _JedisCluster(poolConfig, timeout, RedisClient.removeDuplicate(clusterNodes));
    }

    public RedisClient(GenericObjectPoolConfig poolConfig, String password, HostAndPort ... clusterNodes) {
        this.iJedis = new _JedisCluster(poolConfig, password, RedisClient.removeDuplicate(clusterNodes));
    }

    public RedisClient(GenericObjectPoolConfig poolConfig, int timeout, String password, HostAndPort ... clusterNodes) {
        this.iJedis = new _JedisCluster(poolConfig, timeout, password, clusterNodes);
    }

    public RedisClient(String ... clusterSockets) {
        this(RedisClient.toHostAndPorts(clusterSockets));
    }

    public RedisClient(int timeout, String ... clusterSockets) {
        this(timeout, RedisClient.toHostAndPorts(clusterSockets));
    }

    public RedisClient(String password, String[] clusterSockets) {
        this(password, RedisClient.toHostAndPorts(clusterSockets));
    }

    public RedisClient(int timeout, String password, String ... clusterSockets) {
        this(timeout, password, RedisClient.toHostAndPorts(clusterSockets));
    }

    public RedisClient(GenericObjectPoolConfig poolConfig, int timeout, String ... clusterSockets) {
        this(poolConfig, timeout, RedisClient.toHostAndPorts(clusterSockets));
    }

    public RedisClient(GenericObjectPoolConfig poolConfig, String password, String ... clusterSockets) {
        this(poolConfig, password, RedisClient.toHostAndPorts(clusterSockets));
    }

    public RedisClient(GenericObjectPoolConfig poolConfig, int timeout, String password, String ... clusterSockets) {
        this(poolConfig, timeout, password, RedisClient.toHostAndPorts(clusterSockets));
    }

    private static HostAndPort[] removeDuplicate(HostAndPort[] clusterNodes) {
        LinkedList<HostAndPort> list = new LinkedList<HostAndPort>();
        if (clusterNodes != null) {
            HashSet<String> sockets = new HashSet<String>();
            for (HostAndPort node : clusterNodes) {
                if (!sockets.add(node.toString())) continue;
                list.add(node);
            }
        }
        return RedisClient.toArray(list);
    }

    private static HostAndPort[] toHostAndPorts(String[] clusterSockets) {
        LinkedList<HostAndPort> list = new LinkedList<HostAndPort>();
        if (clusterSockets != null) {
            for (String socket : clusterSockets) {
                HostAndPort hp = RedisClient.toHostAndPort(socket);
                if (hp == null) continue;
                list.add(hp);
            }
        }
        return RedisClient.toArray(list);
    }

    private static HostAndPort toHostAndPort(String socket) {
        HostAndPort hp = null;
        if (StrUtils.isNotTrimEmpty((String)socket)) {
            hp = HostAndPort.from((String)socket);
        }
        return hp;
    }

    private static HostAndPort[] toArray(List<HostAndPort> clusterNodes) {
        HostAndPort[] array = new HostAndPort[clusterNodes.size()];
        for (int i = 0; i < array.length; ++i) {
            array[i] = clusterNodes.get(i);
        }
        return array;
    }

    @Override
    public boolean isVaild() {
        return this.iJedis.isVaild();
    }

    @Override
    public void setAutoCommit(boolean autoCommit) {
        this.iJedis.setAutoCommit(autoCommit);
    }

    @Override
    public void closeAutoCommit() {
        this.iJedis.closeAutoCommit();
    }

    @Override
    public void commit() {
        this.iJedis.commit();
    }

    @Override
    public void destory() {
        this.iJedis.destory();
    }

    public void close() {
        this.destory();
    }

    @Override
    public boolean clearAll() {
        return this.iJedis.clearAll();
    }

    @Override
    public boolean existKey(String redisKey) {
        return this.iJedis.existKey(redisKey);
    }

    @Override
    public long delKeys(String ... redisKeys) {
        return this.iJedis.delKeys(redisKeys);
    }

    @Override
    public boolean addStrVal(String redisKey, String value) {
        return this.iJedis.addStrVal(redisKey, value);
    }

    @Override
    public long appendStrVal(String redisKey, String value) {
        return this.iJedis.appendStrVal(redisKey, value);
    }

    @Override
    public String getStrVal(String redisKey) {
        return this.iJedis.getStrVal(redisKey);
    }

    @Override
    public boolean addSerialObj(String redisKey, Serializable object) {
        return this.iJedis.addSerialObj(redisKey, object);
    }

    @Override
    public Object getSerialObj(String redisKey) {
        return this.iJedis.getSerialObj(redisKey);
    }

    @Override
    public boolean addStrMap(String redisKey, Map<String, String> map) {
        return this.iJedis.addStrMap(redisKey, map);
    }

    @Override
    public boolean addStrValToMap(String redisKey, String key, String value) {
        return this.iJedis.addStrValToMap(redisKey, key, value);
    }

    @Override
    public Map<String, String> getStrMap(String redisKey) {
        return this.iJedis.getStrMap(redisKey);
    }

    @Override
    public String getStrValInMap(String redisKey, String key) {
        return this.iJedis.getStrValInMap(redisKey, key);
    }

    @Override
    public List<String> getStrValsInMap(String redisKey, String ... keys) {
        return this.iJedis.getStrValsInMap(redisKey, keys);
    }

    @Override
    public List<String> getAllStrValsInMap(String redisKey) {
        return this.iJedis.getAllStrValsInMap(redisKey);
    }

    @Override
    public boolean addSerialMap(String redisKey, Map<String, Serializable> map) {
        return this.iJedis.addSerialMap(redisKey, map);
    }

    @Override
    public boolean addSerialObjToMap(String redisKey, String key, Serializable object) {
        return this.iJedis.addSerialObjToMap(redisKey, key, object);
    }

    @Override
    public Map<String, Object> getSerialMap(String redisKey) {
        return this.iJedis.getSerialMap(redisKey);
    }

    @Override
    public Object getSerialObjInMap(String redisKey, String key) {
        return this.iJedis.getSerialObjInMap(redisKey, key);
    }

    @Override
    public List<Object> getSerialObjsInMap(String redisKey, String ... keys) {
        return this.iJedis.getSerialObjsInMap(redisKey, keys);
    }

    @Override
    public List<Object> getAllSerialObjsInMap(String redisKey) {
        return this.iJedis.getAllSerialObjsInMap(redisKey);
    }

    @Override
    public boolean existKeyInMap(String redisKey, String key) {
        return this.iJedis.existKeyInMap(redisKey, key);
    }

    @Override
    public Set<String> getAllKeysInMap(String redisKey) {
        return this.iJedis.getAllKeysInMap(redisKey);
    }

    @Override
    public long delKeysInMap(String redisKey, String ... keys) {
        return this.iJedis.delKeysInMap(redisKey, keys);
    }

    @Override
    public long getMapSize(String redisKey) {
        return this.iJedis.getMapSize(redisKey);
    }

    @Override
    public long addStrList(String redisKey, List<String> list) {
        return this.iJedis.addStrList(redisKey, list);
    }

    @Override
    public long addStrValsToList(String redisKey, String ... values) {
        return this.iJedis.addStrValsToList(redisKey, values);
    }

    @Override
    public long addStrValsToListHead(String redisKey, String ... values) {
        return this.iJedis.addStrValsToListHead(redisKey, values);
    }

    @Override
    public long addStrValsToListTail(String redisKey, String ... values) {
        return this.iJedis.addStrValsToListTail(redisKey, values);
    }

    @Override
    public List<String> getStrList(String redisKey) {
        return this.iJedis.getStrList(redisKey);
    }

    @Override
    public String getStrValInList(String redisKey, long index) {
        return this.iJedis.getStrValInList(redisKey, index);
    }

    @Override
    public List<String> getAllStrValsInList(String redisKey) {
        return this.iJedis.getAllStrValsInList(redisKey);
    }

    @Override
    public long delStrValsInList(String redisKey, String value) {
        return this.iJedis.delStrValsInList(redisKey, value);
    }

    @Override
    public long delStrValsInList(String redisKey, String value, long count) {
        return this.iJedis.delStrValsInList(redisKey, value, count);
    }

    @Override
    public long addSerialList(String redisKey, List<Serializable> list) {
        return this.iJedis.addSerialList(redisKey, list);
    }

    @Override
    public long addSerialObjsToList(String redisKey, Serializable ... objects) {
        return this.iJedis.addSerialObjsToList(redisKey, objects);
    }

    @Override
    public long addSerialObjsToListHead(String redisKey, Serializable ... objects) {
        return this.iJedis.addSerialObjsToListHead(redisKey, objects);
    }

    @Override
    public long addSerialObjsToListTail(String redisKey, Serializable ... objects) {
        return this.iJedis.addSerialObjsToListTail(redisKey, objects);
    }

    @Override
    public long delSerialObjsInList(String redisKey, Serializable object) {
        return this.iJedis.delSerialObjsInList(redisKey, object);
    }

    @Override
    public long delSerialObjsInList(String redisKey, Serializable object, long count) {
        return this.iJedis.delSerialObjsInList(redisKey, object, count);
    }

    @Override
    public List<Object> getSerialList(String redisKey) {
        return this.iJedis.getSerialList(redisKey);
    }

    @Override
    public Object getSerialObjInList(String redisKey, long index) {
        return this.iJedis.getSerialObjInList(redisKey, index);
    }

    @Override
    public List<Object> getAllSerialObjsInList(String redisKey) {
        return this.iJedis.getAllSerialObjsInList(redisKey);
    }

    @Override
    public long getListSize(String redisKey) {
        return this.iJedis.getListSize(redisKey);
    }

    @Override
    public long addStrSet(String redisKey, Set<String> set) {
        return this.iJedis.addStrSet(redisKey, set);
    }

    @Override
    public long addStrValsToSet(String redisKey, String ... values) {
        return this.iJedis.addStrValsToSet(redisKey, values);
    }

    @Override
    public Set<String> getStrSet(String redisKey) {
        return this.iJedis.getStrSet(redisKey);
    }

    @Override
    public String getRandomStrValInSet(String redisKey) {
        return this.iJedis.getRandomStrValInSet(redisKey);
    }

    @Override
    public Set<String> getAllStrValsInSet(String redisKey) {
        return this.iJedis.getAllStrValsInSet(redisKey);
    }

    @Override
    public long delStrValsInSet(String redisKey, String ... values) {
        return this.iJedis.delStrValsInSet(redisKey, values);
    }

    @Override
    public boolean existInSet(String redisKey, String value) {
        return this.iJedis.existInSet(redisKey, value);
    }

    @Override
    public long addSerialSet(String redisKey, Set<Serializable> set) {
        return this.iJedis.addSerialSet(redisKey, set);
    }

    @Override
    public long addSerialObjsToSet(String redisKey, Serializable ... objects) {
        return this.iJedis.addSerialObjsToSet(redisKey, objects);
    }

    @Override
    public Set<Object> getSerialSet(String redisKey) {
        return this.iJedis.getSerialSet(redisKey);
    }

    @Override
    public Object getRandomSerialObjInSet(String redisKey) {
        return this.iJedis.getRandomSerialObjInSet(redisKey);
    }

    @Override
    public Set<Object> getAllSerialObjsInSet(String redisKey) {
        return this.iJedis.getAllSerialObjsInSet(redisKey);
    }

    @Override
    public long delSerialObjsInSet(String redisKey, Serializable ... objects) {
        return this.iJedis.delSerialObjsInSet(redisKey, objects);
    }

    @Override
    public boolean existInSet(String redisKey, Serializable object) {
        return this.iJedis.existInSet(redisKey, object);
    }

    @Override
    public long getSetSize(String redisKey) {
        return this.iJedis.getSetSize(redisKey);
    }
}

