/*
 * Decompiled with CFR 0.152.
 */
package exp.libs.conf.xml;

import exp.libs.conf.xml.XNode;
import exp.libs.conf.xml._Config;
import exp.libs.db.redis.bean.RedisBean;
import exp.libs.db.sql.bean.DataSourceBean;
import exp.libs.utils.num.NumUtils;
import exp.libs.utils.other.BoolUtils;
import exp.libs.utils.str.StrUtils;

public class DBConfig
extends _Config {
    private static volatile DBConfig instance;

    protected DBConfig(String name) {
        super(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static DBConfig getInstn() {
        if (instance != null) return instance;
        Class<DBConfig> clazz = DBConfig.class;
        synchronized (DBConfig.class) {
            if (instance != null) return instance;
            instance = new DBConfig("DEFAULT_DB_CONFIG");
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public DataSourceBean getDataSourceBean(String dsId) {
        DataSourceBean ds = new DataSourceBean();
        if (StrUtils.isEmpty((String)dsId)) {
            return ds;
        }
        String xPath = this.toXPath("datasource", dsId);
        XNode xNode = this.findXNode(xPath);
        if (xNode != NULL_XNODE) {
            ds.setId(dsId);
            ds.setDriver(xNode.getChildVal("driver"));
            ds.setIp(xNode.getChildVal("ip"));
            ds.setPort(NumUtils.toInt((String)xNode.getChildVal("port")));
            ds.setUsername(xNode.getChildVal("username"));
            ds.setPassword(xNode.getChildVal("password"));
            ds.setName(xNode.getChildVal("name"));
            ds.setCharset(xNode.getChildVal("charset"));
            ds.setMaximumActiveTime(NumUtils.toLong((String)xNode.getChildVal("maximum-active-time"), (long)-1L));
            ds.setHouseKeepingTestSql(xNode.getChildVal("house-keeping-test-sql"));
            ds.setHouseKeepingSleepTime(NumUtils.toLong((String)xNode.getChildVal("house-keeping-sleep-time"), (long)-1L));
            ds.setSimultaneousBuildThrottle(NumUtils.toInt((String)xNode.getChildVal("simultaneous-build-throttle"), (int)-1));
            ds.setMaximumConnectionCount(NumUtils.toInt((String)xNode.getChildVal("maximum-connection-count"), (int)-1));
            ds.setMinimumConnectionCount(NumUtils.toInt((String)xNode.getChildVal("minimum-connection-count"), (int)-1));
            ds.setMaximumNewConnections(NumUtils.toInt((String)xNode.getChildVal("maximum-new-connections"), (int)-1));
            ds.setPrototypeCount(NumUtils.toInt((String)xNode.getChildVal("prototype-count"), (int)-1));
            ds.setMaximumConnectionLifetime(NumUtils.toLong((String)xNode.getChildVal("maximum-connection-lifetime"), (long)-1L));
            ds.setTestBeforeUse(BoolUtils.toBool((String)xNode.getChildVal("test-before-use"), (boolean)false));
            ds.setTestAfterUse(BoolUtils.toBool((String)xNode.getChildVal("test-after-use"), (boolean)false));
            ds.setTrace(BoolUtils.toBool((String)xNode.getChildVal("trace"), (boolean)true));
        }
        return ds;
    }

    public RedisBean getRedisBean(String redisId) {
        RedisBean rb = new RedisBean();
        if (StrUtils.isEmpty((String)redisId)) {
            return rb;
        }
        String xPath = this.toXPath("redis", redisId);
        XNode xNode = this.findXNode(xPath);
        if (xNode != NULL_XNODE) {
            rb.setId(redisId);
            rb.setCluster(BoolUtils.toBool((String)xNode.getChildVal("cluster"), (boolean)false));
            rb.addSockets(xNode.getChildVal("sockets"));
            rb.setPassword(xNode.getChildVal("password"));
            rb.setTimeout(NumUtils.toInt((String)xNode.getChildVal("timeout"), (int)0));
            rb.setMaxTotal(NumUtils.toInt((String)xNode.getChildVal("maxTotal"), (int)0));
            rb.setMaxIdle(NumUtils.toInt((String)xNode.getChildVal("maxIdle"), (int)0));
            rb.setMaxWaitMillis(NumUtils.toLong((String)xNode.getChildVal("maxWaitMillis"), (long)-1L));
            rb.setTestOnBorrow(BoolUtils.toBool((String)xNode.getChildVal("testOnBorrow"), (boolean)true));
        }
        return rb;
    }
}

