/*
 * Decompiled with CFR 0.152.
 */
package com.exonum.binding.core.transaction;

import com.exonum.binding.common.crypto.PublicKey;
import com.exonum.binding.common.hash.HashCode;
import com.exonum.binding.core.storage.database.Fork;
import com.exonum.binding.core.transaction.InternalTransactionContext;
import com.google.common.base.Preconditions;

public interface TransactionContext {
    public Fork getFork();

    public HashCode getTransactionMessageHash();

    public PublicKey getAuthorPk();

    public String getServiceName();

    public int getServiceId();

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Fork fork;
        private HashCode hash;
        private PublicKey authorPk;
        private String serviceName;
        private Integer serviceId;

        public Builder fork(Fork fork) {
            this.fork = fork;
            return this;
        }

        public Builder txMessageHash(HashCode hash) {
            this.hash = hash;
            return this;
        }

        public Builder authorPk(PublicKey authorPk) {
            this.authorPk = authorPk;
            return this;
        }

        public Builder serviceName(String serviceName) {
            this.serviceName = serviceName;
            return this;
        }

        public Builder serviceId(int serviceId) {
            this.serviceId = serviceId;
            return this;
        }

        public TransactionContext build() {
            return InternalTransactionContext.newInstance(this.fork, this.hash, this.authorPk, this.serviceName, (Integer)Preconditions.checkNotNull((Object)this.serviceId));
        }

        private Builder() {
        }
    }
}

