/*
 * Decompiled with CFR 0.152.
 */
package com.exonum.binding.core.storage.database;

import com.exonum.binding.core.proxy.AbstractCloseableNativeProxy;
import com.exonum.binding.core.proxy.Cleaner;
import com.exonum.binding.core.proxy.NativeHandle;
import com.exonum.binding.core.storage.database.Database;
import com.exonum.binding.core.storage.database.Fork;
import com.exonum.binding.core.storage.database.Snapshot;
import com.exonum.binding.core.util.LibraryLoader;
import com.google.common.annotations.VisibleForTesting;

public final class TemporaryDb
extends AbstractCloseableNativeProxy
implements Database {
    public static TemporaryDb newInstance() {
        long nativeHandle = 0L;
        try {
            nativeHandle = TemporaryDb.nativeCreate();
            return new TemporaryDb(nativeHandle);
        }
        catch (Throwable t) {
            if (nativeHandle != 0L) {
                TemporaryDb.nativeFree(nativeHandle);
            }
            throw t;
        }
    }

    @VisibleForTesting
    TemporaryDb(long nativeHandle) {
        super(nativeHandle, true);
    }

    @Override
    public Snapshot createSnapshot(Cleaner cleaner) {
        long snapshotHandle = this.nativeCreateSnapshot(this.getNativeHandle());
        return Snapshot.newInstance(snapshotHandle, cleaner);
    }

    @Override
    public Fork createFork(Cleaner cleaner) {
        long forkHandle = this.nativeCreateFork(this.getNativeHandle());
        return Fork.newInstance(forkHandle, cleaner);
    }

    public void merge(Fork fork) {
        NativeHandle patchHandle = fork.intoPatch();
        this.nativeMerge(this.getNativeHandle(), patchHandle.get());
    }

    @Override
    protected void disposeInternal() {
        TemporaryDb.nativeFree(this.getNativeHandle());
    }

    private static native long nativeCreate();

    private native long nativeCreateSnapshot(long var1);

    private native long nativeCreateFork(long var1);

    private native void nativeMerge(long var1, long var3);

    private static native void nativeFree(long var0);

    static {
        LibraryLoader.load();
    }
}

