/*
 * Decompiled with CFR 0.152.
 */
package com.exonum.binding.core.runtime;

import com.exonum.binding.core.runtime.AutoValue_ServiceArtifactId;
import com.exonum.binding.core.runtime.RuntimeId;
import com.google.auto.value.AutoValue;
import com.google.common.base.Preconditions;
import org.apache.logging.log4j.util.Strings;

@AutoValue
public abstract class ServiceArtifactId {
    private static final String DELIMITER = ":";
    private static final int NUM_FIELDS = 2;

    public abstract int getRuntimeId();

    public abstract String getName();

    public static ServiceArtifactId parseFrom(String serviceArtifactId) {
        String[] coordinates = serviceArtifactId.split(DELIMITER, 2);
        int runtimeId = Integer.parseInt(coordinates[0]);
        String name = coordinates[1];
        return ServiceArtifactId.valueOf(runtimeId, name);
    }

    public static ServiceArtifactId newJavaId(String name) {
        return ServiceArtifactId.valueOf(RuntimeId.JAVA.getId(), name);
    }

    public static ServiceArtifactId valueOf(int runtimeId, String name) {
        Preconditions.checkArgument((boolean)Strings.isNotBlank((String)name), (String)"name is blank: '%s'", (Object)name);
        return new AutoValue_ServiceArtifactId(runtimeId, name);
    }

    public final String toString() {
        return this.getRuntimeId() + DELIMITER + this.getName();
    }
}

