/*
 * Decompiled with CFR 0.152.
 */
package com.exonum.binding.core.runtime;

import com.exonum.binding.core.runtime.ClassLoadingScopeChecker;
import com.exonum.binding.core.runtime.JavaArtifactNames;
import com.exonum.binding.core.runtime.LoadedServiceDefinition;
import com.exonum.binding.core.runtime.ReflectiveModuleSupplier;
import com.exonum.binding.core.runtime.ServiceArtifactId;
import com.exonum.binding.core.runtime.ServiceLoader;
import com.exonum.binding.core.runtime.ServiceLoadingException;
import com.exonum.binding.core.service.ServiceModule;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.inject.Inject;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.function.Supplier;
import org.pf4j.Extension;
import org.pf4j.PluginManager;
import org.pf4j.PluginState;

final class Pf4jServiceLoader
implements ServiceLoader {
    private static final Comparator<ServiceArtifactId> SERVICE_ID_COMPARATOR = Comparator.comparing(ServiceArtifactId::getName);
    private final PluginManager pluginManager;
    private final ClassLoadingScopeChecker classLoadingChecker;
    private final SortedMap<ServiceArtifactId, LoadedServiceDefinition> loadedServices;

    @Inject
    Pf4jServiceLoader(PluginManager pluginManager, ClassLoadingScopeChecker classLoadingChecker) {
        this.pluginManager = (PluginManager)Preconditions.checkNotNull((Object)pluginManager);
        this.classLoadingChecker = classLoadingChecker;
        this.loadedServices = new TreeMap<ServiceArtifactId, LoadedServiceDefinition>(SERVICE_ID_COMPARATOR);
    }

    @Override
    public LoadedServiceDefinition loadService(Path artifactPath) throws ServiceLoadingException {
        String pluginId = this.loadPlugin(artifactPath);
        try {
            this.verifyPostLoad(pluginId);
            this.startPlugin(pluginId);
            return this.loadDefinition(pluginId);
        }
        catch (IllegalArgumentException e) {
            this.unloadPlugin(pluginId);
            throw new ServiceLoadingException(String.format("Failed to load plugin %s:", pluginId), e);
        }
        catch (Exception e) {
            this.unloadPlugin(pluginId);
            throw e;
        }
    }

    private String loadPlugin(Path artifactLocation) throws ServiceLoadingException {
        try {
            return this.pluginManager.loadPlugin(artifactLocation);
        }
        catch (Exception e) {
            throw new ServiceLoadingException("Failed to load the service from " + artifactLocation, e);
        }
    }

    private void verifyPostLoad(String pluginId) {
        ClassLoader pluginClassLoader = this.pluginManager.getPluginClassLoader(pluginId);
        this.classLoadingChecker.checkNoCopiesOfAppClasses(pluginClassLoader);
    }

    private void startPlugin(String pluginId) throws ServiceLoadingException {
        try {
            PluginState pluginState = this.pluginManager.startPlugin(pluginId);
            Preconditions.checkState((pluginState == PluginState.STARTED ? 1 : 0) != 0, (String)"Failed to start the plugin %s, its state=%s", (Object)pluginId, (Object)pluginState);
        }
        catch (Exception e) {
            throw new ServiceLoadingException("Failed to start the plugin " + pluginId, e);
        }
    }

    private LoadedServiceDefinition loadDefinition(String pluginId) throws ServiceLoadingException {
        ServiceArtifactId artifactId = Pf4jServiceLoader.extractServiceId(pluginId);
        Supplier<ServiceModule> serviceModuleSupplier = this.findServiceModuleSupplier(pluginId);
        LoadedServiceDefinition serviceDefinition = LoadedServiceDefinition.newInstance(artifactId, serviceModuleSupplier);
        assert (!this.loadedServices.containsKey(artifactId));
        this.loadedServices.put(artifactId, serviceDefinition);
        return serviceDefinition;
    }

    private static ServiceArtifactId extractServiceId(String pluginId) throws ServiceLoadingException {
        try {
            JavaArtifactNames.checkArtifactName(pluginId);
            return ServiceArtifactId.newJavaId(pluginId);
        }
        catch (IllegalArgumentException e) {
            String message = String.format("Invalid plugin id (%s) is specified in service artifact metadata", pluginId);
            throw new ServiceLoadingException(message, e);
        }
    }

    private Supplier<ServiceModule> findServiceModuleSupplier(String pluginId) throws ServiceLoadingException {
        List extensionClasses = this.pluginManager.getExtensionClasses(ServiceModule.class, pluginId);
        this.checkServiceModules(pluginId, extensionClasses);
        Class serviceModuleClass = (Class)extensionClasses.get(0);
        try {
            return new ReflectiveModuleSupplier(serviceModuleClass);
        }
        catch (IllegalAccessException | NoSuchMethodException e) {
            String message = String.format("Cannot load a plugin (%s): module (%s) is not valid", pluginId, serviceModuleClass);
            throw new ServiceLoadingException(message, e);
        }
    }

    private void checkServiceModules(String pluginId, List<Class<? extends ServiceModule>> extensions) throws ServiceLoadingException {
        int numServiceModules = extensions.size();
        if (numServiceModules == 1) {
            return;
        }
        String message = numServiceModules == 0 ? String.format("A plugin (%s) must provide exactly one service module as an extension, but no modules found.%nCheck that your %s implementation is annotated with @%s", pluginId, ServiceModule.class.getSimpleName(), Extension.class.getSimpleName()) : String.format("A plugin (%s) must provide exactly one service module as an extension, but %d modules found:%n%s.%nMultiple modules are not currently supported, but please let us know if you need them.", pluginId, numServiceModules, extensions);
        throw new ServiceLoadingException(message);
    }

    private void unloadPlugin(String pluginId) {
        this.pluginManager.unloadPlugin(pluginId);
    }

    @Override
    public Optional<LoadedServiceDefinition> findService(ServiceArtifactId artifactId) {
        return Optional.ofNullable(this.loadedServices.get(artifactId));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unloadService(ServiceArtifactId artifactId) {
        Preconditions.checkArgument((boolean)this.loadedServices.containsKey(artifactId), (String)"No such artifactId: %s", (Object)artifactId);
        String pluginId = artifactId.getName();
        try {
            boolean stopped = this.pluginManager.unloadPlugin(pluginId);
            Preconditions.checkState((boolean)stopped, (String)"Unknown error whilst unloading the plugin (%s)", (Object)pluginId);
        }
        finally {
            this.loadedServices.remove(artifactId);
        }
    }

    @Override
    public void unloadAll() {
        ArrayList<Exception> errors = new ArrayList<Exception>();
        for (ServiceArtifactId artifactId : this.loadedServices.keySet()) {
            String pluginId = artifactId.getName();
            try {
                this.unloadPlugin(pluginId);
            }
            catch (Exception e) {
                errors.add(e);
            }
        }
        this.loadedServices.clear();
        if (!errors.isEmpty()) {
            IllegalStateException e = new IllegalStateException("Failed to unload some plugins (see suppressed)");
            errors.forEach(e::addSuppressed);
            throw e;
        }
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("loadedServices", this.loadedServices).toString();
    }
}

