/*
 * Decompiled with CFR 0.152.
 */
package com.exonum.binding.core.runtime;

import com.google.common.base.Preconditions;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

final class JavaArtifactNames {
    private static final String DELIMITER = ":";
    private static final Pattern FORBIDDEN_CHARS_PATTERN = Pattern.compile("[\\s:]");
    private static final int KEEP_EMPTY = -1;

    static void checkArtifactName(String name) {
        String[] coordinates = name.split(DELIMITER, -1);
        Preconditions.checkArgument((coordinates.length == 3 ? 1 : 0) != 0, (String)"Invalid artifact name (%s), must have 'groupId:artifactId:version' format", (Object)name);
        for (String c : coordinates) {
            JavaArtifactNames.checkNoForbiddenChars(c);
        }
    }

    private static void checkNoForbiddenChars(String s) {
        Matcher matcher = FORBIDDEN_CHARS_PATTERN.matcher(s);
        if (matcher.find()) {
            throw new IllegalArgumentException(String.format("'%s' must not have any forbidden characters, but there is '%s' at index %d", s, matcher.group(), matcher.start()));
        }
    }

    private JavaArtifactNames() {
    }
}

