/*
 * Decompiled with CFR 0.152.
 */
package com.exonum.binding.core.blockchain.serialization;

import com.exonum.binding.common.hash.HashCode;
import com.exonum.binding.common.hash.Hashing;
import com.exonum.binding.common.serialization.Serializer;
import com.exonum.binding.common.serialization.StandardSerializers;
import com.exonum.binding.core.blockchain.Block;
import com.exonum.core.messages.Blockchain;
import com.exonum.core.messages.Types;
import com.google.protobuf.ByteString;

public enum BlockSerializer implements Serializer<Block>
{
    INSTANCE;

    private static final Serializer<Blockchain.Block> PROTO_SERIALIZER;

    public byte[] toBytes(Block value) {
        Blockchain.Block block = Blockchain.Block.newBuilder().setProposerId(value.getProposerId()).setHeight(value.getHeight()).setTxCount(value.getNumTransactions()).setPrevHash(BlockSerializer.toHashProto(value.getPreviousBlockHash())).setTxHash(BlockSerializer.toHashProto(value.getTxRootHash())).setStateHash(BlockSerializer.toHashProto(value.getStateHash())).build();
        return block.toByteArray();
    }

    public Block fromBytes(byte[] binaryBlock) {
        HashCode blockHash = Hashing.sha256().hashBytes(binaryBlock);
        Blockchain.Block copiedBlocks = (Blockchain.Block)PROTO_SERIALIZER.fromBytes(binaryBlock);
        return Block.builder().proposerId(copiedBlocks.getProposerId()).height(copiedBlocks.getHeight()).numTransactions(copiedBlocks.getTxCount()).blockHash(blockHash).previousBlockHash(BlockSerializer.toHashCode(copiedBlocks.getPrevHash())).txRootHash(BlockSerializer.toHashCode(copiedBlocks.getTxHash())).stateHash(BlockSerializer.toHashCode(copiedBlocks.getStateHash())).build();
    }

    private static Types.Hash toHashProto(HashCode hash) {
        ByteString bytes = ByteString.copyFrom((byte[])hash.asBytes());
        return Types.Hash.newBuilder().setData(bytes).build();
    }

    private static HashCode toHashCode(Types.Hash hash) {
        ByteString bytes = hash.getData();
        return HashCode.fromBytes((byte[])bytes.toByteArray());
    }

    static {
        PROTO_SERIALIZER = StandardSerializers.protobuf(Blockchain.Block.class);
    }
}

