/*
 * Decompiled with CFR 0.152.
 */
package com.exonum.binding.core.storage.indices;

import com.exonum.binding.core.storage.indices.RustIter;
import com.google.common.base.Preconditions;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Optional;

final class RustIterAdapter<E>
implements Iterator<E> {
    private final RustIter<E> rustIter;
    private Optional<E> nextItem;

    RustIterAdapter(RustIter<E> rustIter) {
        this.rustIter = (RustIter)Preconditions.checkNotNull(rustIter);
        this.nextItem = rustIter.next();
    }

    @Override
    public boolean hasNext() {
        return this.nextItem.isPresent();
    }

    @Override
    public E next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException("Reached the end of the underlying collection. Use #hasNext to check if you have reached the end of the collection.");
        }
        Optional<E> nextElement = this.nextItem;
        this.nextItem = this.rustIter.next();
        return nextElement.get();
    }
}

