/*
 * Decompiled with CFR 0.152.
 */
package com.exonum.binding.core.storage.indices;

import com.exonum.binding.common.serialization.Serializer;
import com.exonum.binding.core.storage.indices.StoragePreconditions;
import com.google.common.base.Preconditions;

final class ProofMapKeyCheckingSerializerDecorator<T>
implements Serializer<T> {
    private final Serializer<T> delegate;

    public static <T> ProofMapKeyCheckingSerializerDecorator<T> from(Serializer<T> serializer) {
        if (serializer instanceof ProofMapKeyCheckingSerializerDecorator) {
            return (ProofMapKeyCheckingSerializerDecorator)serializer;
        }
        return new ProofMapKeyCheckingSerializerDecorator<T>(serializer);
    }

    private ProofMapKeyCheckingSerializerDecorator(Serializer<T> delegate) {
        this.delegate = (Serializer)Preconditions.checkNotNull(delegate);
    }

    public byte[] toBytes(T proofKey) {
        byte[] dbValue = this.delegate.toBytes(proofKey);
        return StoragePreconditions.checkProofKey(dbValue);
    }

    public T fromBytes(byte[] serializedProofKey) {
        StoragePreconditions.checkProofKey(serializedProofKey);
        return (T)this.delegate.fromBytes(serializedProofKey);
    }
}

