/*
 * Decompiled with CFR 0.152.
 */
package com.exonum.binding.core.storage.indices;

import com.exonum.binding.core.storage.indices.StoragePreconditions;
import com.google.common.base.MoreObjects;
import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class IndexAddress {
    private final String name;
    private final @Nullable byte[] idInGroup;

    public static IndexAddress valueOf(String name) {
        return new IndexAddress(StoragePreconditions.checkIndexName(name), null);
    }

    public static IndexAddress valueOf(String groupName, byte[] idInGroup) {
        return new IndexAddress(StoragePreconditions.checkIndexName(groupName), StoragePreconditions.checkIdInGroup(idInGroup));
    }

    private IndexAddress(String name, @Nullable byte[] idInGroup) {
        this.name = name;
        this.idInGroup = idInGroup;
    }

    public String getName() {
        return this.name;
    }

    public Optional<byte[]> getIdInGroup() {
        return Optional.ofNullable(this.idInGroup);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof IndexAddress)) {
            return false;
        }
        IndexAddress that = (IndexAddress)o;
        return this.name.equals(that.name) && Arrays.equals(this.idInGroup, that.idInGroup);
    }

    public int hashCode() {
        int result = Objects.hash(this.name);
        result = 31 * result + Arrays.hashCode(this.idInGroup);
        return result;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("name", (Object)this.name).add("idInGroup", (Object)this.idInGroup).omitNullValues().toString();
    }
}

