/*
 * Decompiled with CFR 0.152.
 */
package com.exonum.binding.core.storage.indices;

import com.exonum.binding.core.proxy.AbstractNativeProxy;
import com.exonum.binding.core.proxy.NativeHandle;
import com.exonum.binding.core.storage.database.View;
import com.exonum.binding.core.storage.indices.IndexAddress;
import com.exonum.binding.core.storage.indices.ModificationCounter;
import com.exonum.binding.core.storage.indices.StorageIndex;
import com.google.common.base.Preconditions;

abstract class AbstractIndexProxy
extends AbstractNativeProxy
implements StorageIndex {
    final View dbView;
    final ModificationCounter modCounter;
    private final IndexAddress address;

    AbstractIndexProxy(NativeHandle nativeHandle, IndexAddress address, View view) {
        super(nativeHandle);
        this.address = (IndexAddress)Preconditions.checkNotNull((Object)address);
        this.dbView = view;
        this.modCounter = ModificationCounter.forView(view);
    }

    @Override
    public IndexAddress getAddress() {
        return this.address;
    }

    void notifyModified() {
        this.checkCanModify();
        this.modCounter.notifyModified();
    }

    private void checkCanModify() {
        if (!this.dbView.canModify()) {
            throw new UnsupportedOperationException("Cannot modify the view: " + this.dbView + "\nUse a Fork to modify any collection.");
        }
    }

    public String toString() {
        return this.getName() + ": " + this.getClass().getName();
    }
}

