/*
 * Decompiled with CFR 0.152.
 */
package com.exonum.binding.core.storage.database;

import com.exonum.binding.core.proxy.Cleaner;
import com.exonum.binding.core.proxy.CloseFailuresException;
import com.exonum.binding.core.proxy.NativeHandle;
import com.exonum.binding.core.proxy.ProxyDestructor;
import com.exonum.binding.core.storage.database.View;
import com.exonum.binding.core.storage.database.Views;
import com.google.common.base.Preconditions;

public final class Fork
extends View {
    private final ProxyDestructor destructor;
    private final Cleaner forkCleaner;
    private Cleaner indexCleaner;

    public static Fork newInstance(long nativeHandle, Cleaner cleaner) {
        return Fork.newInstance(nativeHandle, true, cleaner);
    }

    public static Fork newInstance(long nativeHandle, boolean owningHandle, Cleaner cleaner) {
        Preconditions.checkNotNull((Object)cleaner, (Object)"cleaner");
        NativeHandle h = new NativeHandle(nativeHandle);
        ProxyDestructor destructor = ProxyDestructor.newRegistered(cleaner, h, Fork.class, nh -> {
            if (owningHandle) {
                Views.nativeFree(nh);
            }
        });
        return new Fork(h, destructor, cleaner);
    }

    private Fork(NativeHandle nativeHandle, ProxyDestructor destructor, Cleaner parentCleaner) {
        super(nativeHandle, true);
        this.destructor = destructor;
        this.forkCleaner = parentCleaner;
        this.replaceIndexCleaner();
    }

    @Override
    public Cleaner getCleaner() {
        return this.indexCleaner;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    NativeHandle intoPatch() {
        Preconditions.checkState((boolean)Fork.nativeCanConvertIntoPatch(this.getNativeHandle()), (Object)"This fork cannot be converted into patch");
        try {
            this.indexCleaner.close();
        }
        catch (CloseFailuresException e) {
            this.destructor.clean();
            throw new IllegalStateException("intoPatch aborted because some dependent resources did not close properly", e);
        }
        try {
            this.destructor.cancel();
            long patchNativeHandle = Fork.nativeIntoPatch(this.getNativeHandle());
            NativeHandle nativeHandle = new NativeHandle(patchNativeHandle);
            return nativeHandle;
        }
        finally {
            this.nativeHandle.close();
        }
    }

    public void createCheckpoint() {
        Preconditions.checkState((boolean)Fork.nativeCanRollback(this.getNativeHandle()), (Object)"This fork does not support checkpoints");
        this.closeDependentObjects();
        Fork.nativeCreateCheckpoint(this.getNativeHandle());
    }

    public void rollback() {
        Preconditions.checkState((boolean)Fork.nativeCanRollback(this.getNativeHandle()), (Object)"This fork does not support rollbacks");
        this.closeDependentObjects();
        Fork.nativeRollback(this.getNativeHandle());
    }

    private void closeDependentObjects() {
        this.clearOpenIndexes();
        try {
            this.indexCleaner.close();
        }
        catch (CloseFailuresException e) {
            this.destructor.clean();
            throw new IllegalStateException("Operation aborted due to some objects that had failed to close", e);
        }
        this.replaceIndexCleaner();
    }

    private void replaceIndexCleaner() {
        this.indexCleaner = new Cleaner();
        this.forkCleaner.add(this.indexCleaner::close);
    }

    private static native boolean nativeCanConvertIntoPatch(long var0);

    private static native long nativeIntoPatch(long var0);

    private static native boolean nativeCanRollback(long var0);

    private static native void nativeCreateCheckpoint(long var0);

    private static native void nativeRollback(long var0);
}

