/*
 * Decompiled with CFR 0.152.
 */
package com.exonum.binding.core.runtime;

import com.exonum.binding.common.hash.HashCode;
import com.exonum.binding.core.runtime.ServiceConfiguration;
import com.exonum.binding.core.runtime.ServiceInstanceSpec;
import com.exonum.binding.core.service.BlockCommittedEvent;
import com.exonum.binding.core.service.Configurable;
import com.exonum.binding.core.service.Configuration;
import com.exonum.binding.core.service.Node;
import com.exonum.binding.core.service.Service;
import com.exonum.binding.core.service.TransactionConverter;
import com.exonum.binding.core.storage.database.Fork;
import com.exonum.binding.core.storage.database.Snapshot;
import com.exonum.binding.core.transaction.Transaction;
import com.exonum.binding.core.transaction.TransactionContext;
import com.exonum.binding.core.transaction.TransactionExecutionException;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.io.BaseEncoding;
import com.google.common.net.UrlEscapers;
import com.google.inject.Inject;
import io.vertx.ext.web.Router;
import java.util.List;

final class ServiceWrapper {
    static final String DEFAULT_INTERFACE_NAME = "";
    static final int SUPERVISOR_SERVICE_ID = 0;
    @VisibleForTesting
    static final String CONFIGURE_INTERFACE_NAME = "exonum.Configure";
    @VisibleForTesting
    static final int VERIFY_CONFIGURATION_TX_ID = 0;
    @VisibleForTesting
    static final int APPLY_CONFIGURATION_TX_ID = 1;
    private final Service service;
    private final TransactionConverter txConverter;
    private final ServiceInstanceSpec instanceSpec;
    private final Node node;

    @Inject
    ServiceWrapper(Service service, TransactionConverter txConverter, ServiceInstanceSpec instanceSpec, Node node) {
        this.service = service;
        this.txConverter = txConverter;
        this.instanceSpec = instanceSpec;
        this.node = node;
    }

    Service getService() {
        return this.service;
    }

    String getName() {
        return this.instanceSpec.getName();
    }

    int getId() {
        return this.instanceSpec.getId();
    }

    void initialize(Fork view, Configuration configuration) {
        this.service.initialize(view, configuration);
    }

    void executeTransaction(String interfaceName, int txId, byte[] arguments, int callerServiceId, TransactionContext context) throws TransactionExecutionException {
        switch (interfaceName) {
            case "": {
                this.executeIntrinsicTransaction(txId, arguments, context);
                break;
            }
            case "exonum.Configure": {
                this.executeConfigurableTransaction(txId, arguments, callerServiceId, context);
                break;
            }
            default: {
                throw new IllegalArgumentException(String.format("Unknown interface (name=%s, txId=%d)", interfaceName, txId));
            }
        }
    }

    private void executeIntrinsicTransaction(int txId, byte[] arguments, TransactionContext context) throws TransactionExecutionException {
        Transaction transaction = this.convertTransaction(txId, arguments);
        transaction.execute(context);
    }

    Transaction convertTransaction(int txId, byte[] arguments) {
        return this.convertIntrinsicTransaction(txId, arguments);
    }

    private Transaction convertIntrinsicTransaction(int txId, byte[] arguments) {
        Transaction transaction = this.txConverter.toTransaction(txId, arguments);
        if (transaction == null) {
            throw new NullPointerException(String.format("Invalid service implementation: TransactionConverter#toTransaction must never return null.\nThrow an exception if your service does not recognize this message id (%s) or arguments (%s)", txId, BaseEncoding.base16().encode(arguments)));
        }
        return transaction;
    }

    private void executeConfigurableTransaction(int txId, byte[] arguments, int callerServiceId, TransactionContext context) {
        Preconditions.checkArgument((boolean)(this.service instanceof Configurable), (String)"Service (%s) doesn't implement Configurable", (Object)this.getName());
        Preconditions.checkArgument((callerServiceId == 0 ? 1 : 0) != 0, (String)"Invalid caller service id (%s). Operations in Configurable interface may only be invoked by the supervisor service (%s)", (int)callerServiceId, (int)0);
        Configurable configurable = (Configurable)((Object)this.service);
        Fork fork = context.getFork();
        ServiceConfiguration config = new ServiceConfiguration(arguments);
        switch (txId) {
            case 0: {
                configurable.verifyConfiguration(fork, config);
                break;
            }
            case 1: {
                configurable.applyConfiguration(fork, config);
                break;
            }
            default: {
                throw new IllegalArgumentException(String.format("Unknown txId (%d) in Configurable interface", txId));
            }
        }
    }

    List<HashCode> getStateHashes(Snapshot snapshot) {
        return this.service.getStateHashes(snapshot);
    }

    void beforeCommit(Fork fork) {
        this.service.beforeCommit(fork);
    }

    void afterCommit(BlockCommittedEvent event) {
        this.service.afterCommit(event);
    }

    void createPublicApiHandlers(Router router) {
        this.service.createPublicApiHandlers(this.node, router);
    }

    String getPublicApiRelativePath() {
        return UrlEscapers.urlPathSegmentEscaper().escape(this.getName());
    }
}

