/*
 * Decompiled with CFR 0.152.
 */
package com.exonum.binding.core.runtime;

import com.exonum.binding.common.crypto.PublicKey;
import com.exonum.binding.common.hash.HashCode;
import com.exonum.binding.core.proxy.Cleaner;
import com.exonum.binding.core.proxy.CloseFailuresException;
import com.exonum.binding.core.runtime.DeployArguments;
import com.exonum.binding.core.runtime.ServiceArtifactId;
import com.exonum.binding.core.runtime.ServiceInstanceSpec;
import com.exonum.binding.core.runtime.ServiceLoadingException;
import com.exonum.binding.core.runtime.ServiceRuntime;
import com.exonum.binding.core.runtime.ServiceRuntimeProtos;
import com.exonum.binding.core.runtime.ViewFactory;
import com.exonum.binding.core.service.BlockCommittedEventImpl;
import com.exonum.binding.core.service.NodeProxy;
import com.exonum.binding.core.storage.database.Fork;
import com.exonum.binding.core.storage.database.Snapshot;
import com.exonum.binding.core.transaction.TransactionExecutionException;
import com.exonum.core.messages.Runtime;
import com.google.inject.Inject;
import com.google.protobuf.InvalidProtocolBufferException;
import java.util.OptionalInt;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ServiceRuntimeAdapter {
    private final ServiceRuntime serviceRuntime;
    private final ViewFactory viewFactory;
    private static final Logger logger = LogManager.getLogger(ServiceRuntimeAdapter.class);

    @Inject
    public ServiceRuntimeAdapter(ServiceRuntime serviceRuntime, ViewFactory viewFactory) {
        this.serviceRuntime = serviceRuntime;
        this.viewFactory = viewFactory;
    }

    public ServiceRuntime getServiceRuntime() {
        return this.serviceRuntime;
    }

    void initialize(long nodeNativeHandle) {
        NodeProxy node = new NodeProxy(nodeNativeHandle);
        this.serviceRuntime.initialize(node);
    }

    void deployArtifact(String name, byte[] deploySpec) throws ServiceLoadingException {
        DeployArguments deployArguments = ServiceRuntimeAdapter.parseDeployArgs(name, deploySpec);
        String artifactFilename = deployArguments.getArtifactFilename();
        this.serviceRuntime.deployArtifact(ServiceArtifactId.newJavaId(name), artifactFilename);
    }

    boolean isArtifactDeployed(String name) {
        ServiceArtifactId artifactId = ServiceArtifactId.newJavaId(name);
        return this.serviceRuntime.isArtifactDeployed(artifactId);
    }

    private static DeployArguments parseDeployArgs(String name, byte[] deploySpec) {
        try {
            return DeployArguments.parseFrom(deploySpec);
        }
        catch (InvalidProtocolBufferException e) {
            String message = "Invalid deploy specification for " + name;
            logger.error(message, (Throwable)e);
            throw new IllegalArgumentException(message, e);
        }
    }

    void startAddingService(long forkHandle, byte[] instanceSpec, byte[] configuration) throws CloseFailuresException {
        try (Cleaner cleaner = new Cleaner();){
            Fork fork = this.viewFactory.createFork(forkHandle, cleaner);
            ServiceInstanceSpec javaInstanceSpec = ServiceRuntimeAdapter.parseInstanceSpec(instanceSpec);
            this.serviceRuntime.startAddingService(fork, javaInstanceSpec, configuration);
        }
        catch (CloseFailuresException e) {
            ServiceRuntimeAdapter.handleCloseFailure(e);
        }
    }

    void commitService(byte[] instanceSpec) {
        ServiceInstanceSpec javaInstanceSpec = ServiceRuntimeAdapter.parseInstanceSpec(instanceSpec);
        this.serviceRuntime.commitService(javaInstanceSpec);
    }

    private static ServiceInstanceSpec parseInstanceSpec(byte[] instanceSpec) {
        try {
            Runtime.InstanceSpec spec = Runtime.InstanceSpec.parseFrom((byte[])instanceSpec);
            Runtime.ArtifactId artifact = spec.getArtifact();
            ServiceArtifactId artifactId = ServiceArtifactId.valueOf(artifact.getRuntimeId(), artifact.getName());
            return ServiceInstanceSpec.newInstance(spec.getName(), spec.getId(), artifactId);
        }
        catch (InvalidProtocolBufferException e) {
            logger.error((Object)e);
            throw new IllegalArgumentException(e);
        }
    }

    void executeTransaction(int serviceId, String interfaceName, int txId, byte[] arguments, long forkNativeHandle, int callerServiceId, byte[] txMessageHash, byte[] authorPublicKey) throws TransactionExecutionException, CloseFailuresException {
        try (Cleaner cleaner = new Cleaner("executeTransaction");){
            Fork fork = this.viewFactory.createFork(forkNativeHandle, cleaner);
            HashCode hash = HashCode.fromBytes((byte[])txMessageHash);
            PublicKey authorPk = PublicKey.fromBytes((byte[])authorPublicKey);
            this.serviceRuntime.executeTransaction(serviceId, interfaceName, txId, arguments, fork, callerServiceId, hash, authorPk);
        }
        catch (CloseFailuresException e) {
            ServiceRuntimeAdapter.handleCloseFailure(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    byte[] getStateHashes(long snapshotHandle) throws CloseFailuresException {
        try (Cleaner cleaner = new Cleaner("getStateHashes");){
            Snapshot snapshot = this.viewFactory.createSnapshot(snapshotHandle, cleaner);
            ServiceRuntimeProtos.ServiceRuntimeStateHashes stateHashes = this.serviceRuntime.getStateHashes(snapshot);
            byte[] byArray = stateHashes.toByteArray();
            return byArray;
        }
        catch (CloseFailuresException e) {
            ServiceRuntimeAdapter.handleCloseFailure(e);
            return null;
        }
    }

    void beforeCommit(int serviceId, long forkHandle) throws CloseFailuresException {
        try (Cleaner cleaner = new Cleaner("beforeCommit");){
            Fork fork = this.viewFactory.createFork(forkHandle, cleaner);
            this.serviceRuntime.beforeCommit(serviceId, fork);
        }
        catch (CloseFailuresException e) {
            ServiceRuntimeAdapter.handleCloseFailure(e);
        }
    }

    void afterCommit(long snapshotHandle, int validatorId, long height) throws CloseFailuresException {
        try (Cleaner cleaner = new Cleaner("afterCommit");){
            Snapshot snapshot = this.viewFactory.createSnapshot(snapshotHandle, cleaner);
            OptionalInt optionalValidatorId = validatorId >= 0 ? OptionalInt.of(validatorId) : OptionalInt.empty();
            BlockCommittedEventImpl event = BlockCommittedEventImpl.valueOf(snapshot, optionalValidatorId, height);
            this.serviceRuntime.afterCommit(event);
        }
        catch (CloseFailuresException e) {
            ServiceRuntimeAdapter.handleCloseFailure(e);
        }
    }

    void shutdown() throws InterruptedException {
        this.serviceRuntime.shutdown();
    }

    private static void handleCloseFailure(CloseFailuresException e) throws CloseFailuresException {
        logger.error("Failed to close some resources", (Throwable)e);
        throw e;
    }
}

