/*
 * Decompiled with CFR 0.152.
 */
package com.exonum.binding.core.runtime;

import com.exonum.binding.common.crypto.PublicKey;
import com.exonum.binding.common.hash.HashCode;
import com.exonum.binding.core.runtime.LoadedServiceDefinition;
import com.exonum.binding.core.runtime.RuntimeTransport;
import com.exonum.binding.core.runtime.ServiceArtifactId;
import com.exonum.binding.core.runtime.ServiceConfiguration;
import com.exonum.binding.core.runtime.ServiceInstanceSpec;
import com.exonum.binding.core.runtime.ServiceLoader;
import com.exonum.binding.core.runtime.ServiceLoadingException;
import com.exonum.binding.core.runtime.ServiceRuntimeProtos;
import com.exonum.binding.core.runtime.ServiceWrapper;
import com.exonum.binding.core.runtime.ServicesFactory;
import com.exonum.binding.core.service.BlockCommittedEvent;
import com.exonum.binding.core.service.Node;
import com.exonum.binding.core.storage.database.Fork;
import com.exonum.binding.core.storage.database.Snapshot;
import com.exonum.binding.core.transaction.TransactionContext;
import com.exonum.binding.core.transaction.TransactionExecutionException;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.google.inject.name.Named;
import com.google.protobuf.ByteString;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Singleton
public final class ServiceRuntime
implements AutoCloseable {
    @VisibleForTesting
    static final String API_ROOT_PATH = "/api/services";
    private static final Logger logger = LogManager.getLogger(ServiceRuntime.class);
    private final ServiceLoader serviceLoader;
    private final ServicesFactory servicesFactory;
    private final RuntimeTransport runtimeTransport;
    private final Path artifactsDir;
    private final SortedMap<String, ServiceWrapper> services = new TreeMap<String, ServiceWrapper>();
    private final Map<Integer, ServiceWrapper> servicesById = new HashMap<Integer, ServiceWrapper>();
    private final Object lock = new Object();
    private Node node;

    @Inject
    public ServiceRuntime(ServiceLoader serviceLoader, ServicesFactory servicesFactory, RuntimeTransport runtimeTransport, @Named(value="ServiceRuntime artifacts dir") Path artifactsDir) {
        this.serviceLoader = (ServiceLoader)Preconditions.checkNotNull((Object)serviceLoader);
        this.servicesFactory = (ServicesFactory)Preconditions.checkNotNull((Object)servicesFactory);
        this.runtimeTransport = (RuntimeTransport)Preconditions.checkNotNull((Object)runtimeTransport);
        this.artifactsDir = (Path)Preconditions.checkNotNull((Object)artifactsDir);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialize(Node node) {
        Object object = this.lock;
        synchronized (object) {
            Preconditions.checkState((this.node == null ? 1 : 0) != 0, (String)"Invalid attempt to replace already set node (%s) with %s", (Object)this.node, (Object)node);
            this.node = (Node)Preconditions.checkNotNull((Object)node);
            this.runtimeTransport.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deployArtifact(ServiceArtifactId id, String filename) throws ServiceLoadingException {
        try {
            Object object = this.lock;
            synchronized (object) {
                Preconditions.checkState((boolean)Files.isDirectory(this.artifactsDir, new LinkOption[0]), (String)"Artifacts dir (%s) does not exist or is not a directory: check the runtime configuration", (Object)this.artifactsDir);
                Path artifactLocation = this.artifactsDir.resolve(filename);
                LoadedServiceDefinition loadedServiceDefinition = this.serviceLoader.loadService(artifactLocation);
                ServiceArtifactId actualId = loadedServiceDefinition.getId();
                if (!actualId.equals(id)) {
                    this.serviceLoader.unloadService(actualId);
                    throw new ServiceLoadingException(String.format("The artifact loaded from (%s) has wrong id (%s) in metadata. Expected id: %s", filename, actualId, id));
                }
            }
            logger.info("Loaded an artifact ({}) from {}", (Object)id, (Object)filename);
        }
        catch (Throwable e) {
            logger.error("Failed to load an artifact {} from {}", (Object)id, (Object)filename, (Object)e);
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isArtifactDeployed(ServiceArtifactId id) {
        Object object = this.lock;
        synchronized (object) {
            return this.serviceLoader.findService(id).isPresent();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startAddingService(Fork fork, ServiceInstanceSpec instanceSpec, byte[] configuration) {
        try {
            Object object = this.lock;
            synchronized (object) {
                ServiceWrapper service = this.createService(instanceSpec);
                service.initialize(fork, new ServiceConfiguration(configuration));
            }
            logger.info("Initialized a new service: {}", (Object)instanceSpec);
        }
        catch (Exception e) {
            logger.error("Failed to initialize a service {} instance with parameters {}", (Object)instanceSpec, (Object)configuration, (Object)e);
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commitService(ServiceInstanceSpec instanceSpec) {
        try {
            Object object = this.lock;
            synchronized (object) {
                ServiceWrapper service = this.createService(instanceSpec);
                this.registerService(service);
                this.connectServiceApi(service);
            }
            logger.info("Added a service: {}", (Object)instanceSpec);
        }
        catch (Exception e) {
            logger.error("Failed to add a service {} instance", (Object)instanceSpec, (Object)e);
            throw e;
        }
    }

    private ServiceWrapper createService(ServiceInstanceSpec instanceSpec) {
        String name = instanceSpec.getName();
        Preconditions.checkArgument((!this.findService(name).isPresent() ? 1 : 0) != 0, (String)"Service with name '%s' already created: %s", (Object)name, this.services.get(name));
        ServiceArtifactId artifactId = instanceSpec.getArtifactId();
        LoadedServiceDefinition serviceDefinition = this.serviceLoader.findService(artifactId).orElseThrow(() -> new IllegalArgumentException("Unknown artifactId: " + artifactId));
        return this.servicesFactory.createService(serviceDefinition, instanceSpec, this.node);
    }

    private void registerService(ServiceWrapper service) {
        String name = service.getName();
        this.services.put(name, service);
        int id = service.getId();
        this.servicesById.put(id, service);
    }

    private void connectServiceApi(ServiceWrapper service) {
        try {
            this.runtimeTransport.connectServiceApi(service);
        }
        catch (Exception e) {
            logger.error("Failed to connect service {} public API. Its HTTP handlers will likely be inaccessible", (Object)service.getName(), (Object)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeTransaction(int serviceId, String interfaceName, int txId, byte[] arguments, Fork fork, int callerServiceId, HashCode txMessageHash, PublicKey authorPublicKey) throws TransactionExecutionException {
        Object object = this.lock;
        synchronized (object) {
            ServiceWrapper service = this.getServiceById(serviceId);
            String serviceName = service.getName();
            TransactionContext context = TransactionContext.builder().fork(fork).txMessageHash(txMessageHash).authorPk(authorPublicKey).serviceName(serviceName).serviceId(serviceId).build();
            try {
                service.executeTransaction(interfaceName, txId, arguments, callerServiceId, context);
            }
            catch (Exception e) {
                logger.info("Transaction execution failed (service={}, txId={}, txMessageHash={})", (Object)service.getName(), (Object)txId, (Object)context.getTransactionMessageHash(), (Object)e);
                throw e;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServiceRuntimeProtos.ServiceRuntimeStateHashes getStateHashes(Snapshot snapshot) {
        Object object = this.lock;
        synchronized (object) {
            List serviceStateHashes = this.services.values().stream().map(service -> this.getServiceStateHashes((ServiceWrapper)service, snapshot)).collect(Collectors.toList());
            return ServiceRuntimeProtos.ServiceRuntimeStateHashes.newBuilder().addAllServiceStateHashes(serviceStateHashes).build();
        }
    }

    private ServiceRuntimeProtos.ServiceStateHashes getServiceStateHashes(ServiceWrapper service, Snapshot snapshot) {
        List<HashCode> stateHashes = service.getStateHashes(snapshot);
        List stateHashesAsBytes = stateHashes.stream().map(hash -> ByteString.copyFrom((byte[])hash.asBytes())).collect(Collectors.toList());
        return ServiceRuntimeProtos.ServiceStateHashes.newBuilder().setInstanceId(service.getId()).addAllStateHashes(stateHashesAsBytes).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void beforeCommit(int serviceId, Fork fork) {
        Object object = this.lock;
        synchronized (object) {
            ServiceWrapper service = this.getServiceById(serviceId);
            try {
                service.beforeCommit(fork);
            }
            catch (Exception e) {
                logger.error("Service {} threw exception in beforeCommit. Any changes will be rolled-back", (Object)service.getName(), (Object)e);
                throw e;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterCommit(BlockCommittedEvent event) {
        Object object = this.lock;
        synchronized (object) {
            for (ServiceWrapper service : this.services.values()) {
                try {
                    service.afterCommit(event);
                }
                catch (Exception e) {
                    logger.error("Service {} threw an exception in its afterCommit handler of {}", (Object)service.getName(), (Object)event, (Object)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void verifyTransaction(int serviceId, int txId, byte[] arguments) {
        Object object = this.lock;
        synchronized (object) {
            ServiceWrapper service = this.getServiceById(serviceId);
            service.convertTransaction(txId, arguments);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() throws InterruptedException {
        Object object = this.lock;
        synchronized (object) {
            try {
                logger.info("Shutting down the runtime");
                this.stopServer();
                this.clearServices();
                this.unloadArtifacts();
                logger.info("The runtime shutdown complete");
            }
            catch (Exception e) {
                logger.error("Shutdown failure", (Throwable)e);
                throw e;
            }
        }
    }

    private void stopServer() throws InterruptedException {
        try {
            logger.info("Requesting the HTTP server to stop");
            this.runtimeTransport.close();
            logger.info("Stopped the HTTP server");
        }
        catch (InterruptedException e) {
            logger.warn("Interrupted before completion");
            throw e;
        }
        catch (Exception e) {
            logger.error("Exception occurred whilst stopping the server", (Throwable)e);
        }
    }

    private void clearServices() {
        this.services.clear();
        this.servicesById.clear();
    }

    private void unloadArtifacts() {
        try {
            logger.info("Unloading the artifacts");
            this.serviceLoader.unloadAll();
            logger.info("Unloaded the artifacts");
        }
        catch (IllegalStateException e) {
            logger.error("Unload failure", (Throwable)e);
        }
    }

    @Override
    public void close() throws InterruptedException {
        this.shutdown();
    }

    private ServiceWrapper getServiceById(Integer serviceId) {
        this.checkService(serviceId);
        return this.servicesById.get(serviceId);
    }

    private void checkService(Integer serviceId) {
        Preconditions.checkArgument((boolean)this.servicesById.containsKey(serviceId), (String)"No service with id=%s in the Java runtime", (Object)serviceId);
    }

    @VisibleForTesting
    Optional<ServiceWrapper> findService(String name) {
        return Optional.ofNullable(this.services.get(name));
    }
}

