/*
 * Decompiled with CFR 0.152.
 */
package com.exonum.binding.core.runtime;

import com.google.inject.Inject;
import com.google.inject.name.Named;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

class ClassLoadingScopeChecker {
    static final String DEPENDENCY_REFERENCE_CLASSES_KEY = "Dependency reference classes";
    private final Map<String, Class<?>> dependencyReferenceClasses;

    @Inject
    ClassLoadingScopeChecker(@Named(value="Dependency reference classes") Map<String, Class<?>> dependencyReferenceClasses) {
        this.dependencyReferenceClasses = dependencyReferenceClasses;
    }

    void checkNoCopiesOfAppClasses(ClassLoader pluginClassloader) {
        List libraryCopies = this.dependencyReferenceClasses.entrySet().stream().filter(e -> this.loadsCopyOf(pluginClassloader, (Map.Entry<String, Class<?>>)e)).map(Map.Entry::getKey).collect(Collectors.toList());
        if (libraryCopies.isEmpty()) {
            return;
        }
        String message = String.format("Classloader (%s) loads copies of the following libraries: %s.%nPlease ensure in your service build definition that each of these libraries:%n  1. Has 'provided' scope%n  2. Does not specify its version (i.e., inherits it from exonum-java-binding-bom)%nSee also: https://exonum.com/doc/version/0.13-rc.2/get-started/java-binding/#using-libraries", pluginClassloader, libraryCopies);
        throw new IllegalArgumentException(message);
    }

    private boolean loadsCopyOf(ClassLoader pluginClassloader, Map.Entry<String, Class<?>> referenceEntry) {
        String libraryName = referenceEntry.getKey();
        Class<?> referenceClass = referenceEntry.getValue();
        String referenceClassName = referenceClass.getName();
        try {
            Class<?> loadedThruPlugin = pluginClassloader.loadClass(referenceClassName);
            return referenceClass != loadedThruPlugin;
        }
        catch (ClassNotFoundException e) {
            String message = String.format("Classloader (%s) failed to load the reference application class (%s) from %s library", pluginClassloader, referenceClass, libraryName);
            throw new IllegalStateException(message, e);
        }
    }
}

