/*
 * Decompiled with CFR 0.152.
 */
package com.exonum.binding.core.blockchain.serialization;

import com.exonum.binding.common.blockchain.TransactionLocation;
import com.exonum.binding.common.serialization.Serializer;
import com.exonum.binding.common.serialization.StandardSerializers;
import com.exonum.core.messages.Blockchain;

public enum TransactionLocationSerializer implements Serializer<TransactionLocation>
{
    INSTANCE;

    private static final Serializer<Blockchain.TxLocation> PROTO_SERIALIZER;

    public byte[] toBytes(TransactionLocation value) {
        return Blockchain.TxLocation.newBuilder().setBlockHeight(value.getHeight()).setPositionInBlock(value.getIndexInBlock()).build().toByteArray();
    }

    public TransactionLocation fromBytes(byte[] binaryTransactionLocation) {
        Blockchain.TxLocation copiedtxLocationProtos = (Blockchain.TxLocation)PROTO_SERIALIZER.fromBytes(binaryTransactionLocation);
        return TransactionLocation.valueOf((long)copiedtxLocationProtos.getBlockHeight(), (long)copiedtxLocationProtos.getPositionInBlock());
    }

    static {
        PROTO_SERIALIZER = StandardSerializers.protobuf(Blockchain.TxLocation.class);
    }
}

