package com.exonum.binding.core.transaction;

import com.exonum.binding.common.crypto.PublicKey;
import com.exonum.binding.common.hash.HashCode;
import com.exonum.binding.core.storage.database.Fork;
import javax.annotation.Generated;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_InternalTransactionContext extends InternalTransactionContext {

  private final Fork fork;

  private final HashCode transactionMessageHash;

  private final PublicKey authorPk;

  private final String serviceName;

  private final int serviceId;

  AutoValue_InternalTransactionContext(
      Fork fork,
      HashCode transactionMessageHash,
      PublicKey authorPk,
      String serviceName,
      int serviceId) {
    if (fork == null) {
      throw new NullPointerException("Null fork");
    }
    this.fork = fork;
    if (transactionMessageHash == null) {
      throw new NullPointerException("Null transactionMessageHash");
    }
    this.transactionMessageHash = transactionMessageHash;
    if (authorPk == null) {
      throw new NullPointerException("Null authorPk");
    }
    this.authorPk = authorPk;
    if (serviceName == null) {
      throw new NullPointerException("Null serviceName");
    }
    this.serviceName = serviceName;
    this.serviceId = serviceId;
  }

  @Override
  public Fork getFork() {
    return fork;
  }

  @Override
  public HashCode getTransactionMessageHash() {
    return transactionMessageHash;
  }

  @Override
  public PublicKey getAuthorPk() {
    return authorPk;
  }

  @Override
  public String getServiceName() {
    return serviceName;
  }

  @Override
  public int getServiceId() {
    return serviceId;
  }

  @Override
  public String toString() {
    return "InternalTransactionContext{"
         + "fork=" + fork + ", "
         + "transactionMessageHash=" + transactionMessageHash + ", "
         + "authorPk=" + authorPk + ", "
         + "serviceName=" + serviceName + ", "
         + "serviceId=" + serviceId
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof InternalTransactionContext) {
      InternalTransactionContext that = (InternalTransactionContext) o;
      return this.fork.equals(that.getFork())
          && this.transactionMessageHash.equals(that.getTransactionMessageHash())
          && this.authorPk.equals(that.getAuthorPk())
          && this.serviceName.equals(that.getServiceName())
          && this.serviceId == that.getServiceId();
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= fork.hashCode();
    h$ *= 1000003;
    h$ ^= transactionMessageHash.hashCode();
    h$ *= 1000003;
    h$ ^= authorPk.hashCode();
    h$ *= 1000003;
    h$ ^= serviceName.hashCode();
    h$ *= 1000003;
    h$ ^= serviceId;
    return h$;
  }

}
