/*
 * Decompiled with CFR 0.152.
 */
package com.exonum.binding.core.storage.indices;

import com.exonum.binding.common.hash.HashCode;
import com.exonum.binding.common.proofs.list.UncheckedListProof;
import com.exonum.binding.common.proofs.list.UncheckedListProofAdapter;
import com.exonum.binding.common.serialization.CheckingSerializerDecorator;
import com.exonum.binding.common.serialization.Serializer;
import com.exonum.binding.common.serialization.StandardSerializers;
import com.exonum.binding.core.proxy.Cleaner;
import com.exonum.binding.core.proxy.NativeHandle;
import com.exonum.binding.core.proxy.ProxyDestructor;
import com.exonum.binding.core.storage.database.View;
import com.exonum.binding.core.storage.indices.AbstractListIndexProxy;
import com.exonum.binding.core.storage.indices.IndexAddress;
import com.exonum.binding.core.storage.indices.ListIndex;
import com.exonum.binding.core.storage.indices.StorageIndex;
import com.exonum.binding.core.storage.indices.StoragePreconditions;
import com.exonum.binding.core.util.LibraryLoader;
import com.google.protobuf.MessageLite;
import java.util.function.LongSupplier;

public final class ProofListIndexProxy<E>
extends AbstractListIndexProxy<E>
implements ListIndex<E> {
    public static <E extends MessageLite> ProofListIndexProxy<E> newInstance(String name, View view, Class<E> elementType) {
        return ProofListIndexProxy.newInstance(name, view, StandardSerializers.protobuf(elementType));
    }

    public static <E> ProofListIndexProxy<E> newInstance(String name, View view, Serializer<E> serializer) {
        IndexAddress address = IndexAddress.valueOf(name);
        long viewNativeHandle = view.getViewNativeHandle();
        LongSupplier nativeListConstructor = () -> ProofListIndexProxy.nativeCreate(name, viewNativeHandle);
        return ProofListIndexProxy.getOrCreate(address, view, serializer, nativeListConstructor);
    }

    private static native long nativeCreate(String var0, long var1);

    public static <E> ProofListIndexProxy<E> newInGroupUnsafe(String groupName, byte[] listId, View view, Serializer<E> serializer) {
        IndexAddress address = IndexAddress.valueOf(groupName, listId);
        long viewNativeHandle = view.getViewNativeHandle();
        LongSupplier nativeListConstructor = () -> ProofListIndexProxy.nativeCreateInGroup(groupName, listId, viewNativeHandle);
        return ProofListIndexProxy.getOrCreate(address, view, serializer, nativeListConstructor);
    }

    private static native long nativeCreateInGroup(String var0, byte[] var1, long var2);

    private static <E> ProofListIndexProxy<E> getOrCreate(IndexAddress address, View view, Serializer<E> serializer, LongSupplier nativeListConstructor) {
        return view.findOpenIndex(address).map(ProofListIndexProxy::checkCachedInstance).orElseGet(() -> ProofListIndexProxy.newListIndexProxy(address, view, serializer, nativeListConstructor));
    }

    private static <E> ProofListIndexProxy<E> checkCachedInstance(StorageIndex cachedIndex) {
        StoragePreconditions.checkIndexType(cachedIndex, ProofListIndexProxy.class);
        return (ProofListIndexProxy)cachedIndex;
    }

    private static <E> ProofListIndexProxy<E> newListIndexProxy(IndexAddress address, View view, Serializer<E> serializer, LongSupplier nativeListConstructor) {
        CheckingSerializerDecorator s = CheckingSerializerDecorator.from(serializer);
        NativeHandle listNativeHandle = ProofListIndexProxy.createNativeList(view, nativeListConstructor);
        ProofListIndexProxy<E> list = new ProofListIndexProxy<E>(listNativeHandle, address, view, s);
        view.registerIndex(list);
        return list;
    }

    private static NativeHandle createNativeList(View view, LongSupplier nativeListConstructor) {
        NativeHandle listNativeHandle = new NativeHandle(nativeListConstructor.getAsLong());
        Cleaner cleaner = view.getCleaner();
        ProxyDestructor.newRegistered(cleaner, listNativeHandle, ProofListIndexProxy.class, ProofListIndexProxy::nativeFree);
        return listNativeHandle;
    }

    private ProofListIndexProxy(NativeHandle nativeHandle, IndexAddress address, View view, CheckingSerializerDecorator<E> serializer) {
        super(nativeHandle, address, view, serializer);
    }

    public UncheckedListProof getProof(long index) {
        return this.nativeGetProof(this.getNativeHandle(), index);
    }

    private native UncheckedListProofAdapter nativeGetProof(long var1, long var3);

    public UncheckedListProof getRangeProof(long from, long to) {
        StoragePreconditions.checkRange(from, to);
        return this.nativeGetRangeProof(this.getNativeHandle(), from, to);
    }

    private native UncheckedListProofAdapter nativeGetRangeProof(long var1, long var3, long var5);

    public HashCode getIndexHash() {
        return HashCode.fromBytes((byte[])this.nativeGetIndexHash(this.getNativeHandle()));
    }

    private native byte[] nativeGetIndexHash(long var1);

    private static native void nativeFree(long var0);

    @Override
    native void nativeAdd(long var1, byte[] var3);

    @Override
    native void nativeSet(long var1, long var3, byte[] var5);

    @Override
    native byte[] nativeGet(long var1, long var3);

    @Override
    native byte[] nativeGetLast(long var1);

    @Override
    native void nativeClear(long var1);

    @Override
    native boolean nativeIsEmpty(long var1);

    @Override
    native long nativeSize(long var1);

    @Override
    native long nativeCreateIter(long var1);

    @Override
    native byte[] nativeIterNext(long var1);

    @Override
    native void nativeIterFree(long var1);

    static {
        LibraryLoader.load();
    }
}

