/*
 * Decompiled with CFR 0.152.
 */
package com.exonum.binding.core.storage.indices;

import com.exonum.binding.common.serialization.CheckingSerializerDecorator;
import com.exonum.binding.common.serialization.Serializer;
import com.exonum.binding.common.serialization.StandardSerializers;
import com.exonum.binding.core.proxy.Cleaner;
import com.exonum.binding.core.proxy.NativeHandle;
import com.exonum.binding.core.proxy.ProxyDestructor;
import com.exonum.binding.core.storage.database.View;
import com.exonum.binding.core.storage.indices.AbstractListIndexProxy;
import com.exonum.binding.core.storage.indices.IndexAddress;
import com.exonum.binding.core.storage.indices.ListIndex;
import com.exonum.binding.core.storage.indices.StorageIndex;
import com.exonum.binding.core.storage.indices.StoragePreconditions;
import com.exonum.binding.core.util.LibraryLoader;
import com.google.common.base.Preconditions;
import com.google.protobuf.MessageLite;
import java.util.NoSuchElementException;
import java.util.function.LongSupplier;

public final class ListIndexProxy<E>
extends AbstractListIndexProxy<E>
implements ListIndex<E> {
    public static <E extends MessageLite> ListIndexProxy<E> newInstance(String name, View view, Class<E> elementType) {
        return ListIndexProxy.newInstance(name, view, StandardSerializers.protobuf(elementType));
    }

    public static <E> ListIndexProxy<E> newInstance(String name, View view, Serializer<E> serializer) {
        IndexAddress address = IndexAddress.valueOf(name);
        long viewNativeHandle = view.getViewNativeHandle();
        LongSupplier nativeListConstructor = () -> ListIndexProxy.nativeCreate(name, viewNativeHandle);
        return ListIndexProxy.getOrCreate(address, view, serializer, nativeListConstructor);
    }

    public static <E> ListIndexProxy<E> newInGroupUnsafe(String groupName, byte[] listId, View view, Serializer<E> serializer) {
        IndexAddress address = IndexAddress.valueOf(groupName, listId);
        long viewNativeHandle = view.getViewNativeHandle();
        LongSupplier nativeListConstructor = () -> ListIndexProxy.nativeCreateInGroup(groupName, listId, viewNativeHandle);
        return ListIndexProxy.getOrCreate(address, view, serializer, nativeListConstructor);
    }

    private static <E> ListIndexProxy<E> getOrCreate(IndexAddress address, View view, Serializer<E> serializer, LongSupplier nativeListConstructor) {
        return view.findOpenIndex(address).map(ListIndexProxy::checkCachedInstance).orElseGet(() -> ListIndexProxy.newListIndexProxy(address, view, serializer, nativeListConstructor));
    }

    private static <E> ListIndexProxy<E> checkCachedInstance(StorageIndex cachedIndex) {
        StoragePreconditions.checkIndexType(cachedIndex, ListIndexProxy.class);
        return (ListIndexProxy)cachedIndex;
    }

    private static <E> ListIndexProxy<E> newListIndexProxy(IndexAddress address, View view, Serializer<E> serializer, LongSupplier nativeSetConstructor) {
        CheckingSerializerDecorator s = CheckingSerializerDecorator.from(serializer);
        NativeHandle listNativeHandle = ListIndexProxy.createNativeList(view, nativeSetConstructor);
        ListIndexProxy<E> list = new ListIndexProxy<E>(listNativeHandle, address, view, s);
        view.registerIndex(list);
        return list;
    }

    private static NativeHandle createNativeList(View view, LongSupplier nativeListConstructor) {
        NativeHandle listNativeHandle = new NativeHandle(nativeListConstructor.getAsLong());
        Cleaner cleaner = view.getCleaner();
        ProxyDestructor.newRegistered(cleaner, listNativeHandle, ListIndexProxy.class, ListIndexProxy::nativeFree);
        return listNativeHandle;
    }

    private ListIndexProxy(NativeHandle nativeHandle, IndexAddress address, View view, CheckingSerializerDecorator<E> serializer) {
        super(nativeHandle, address, view, serializer);
    }

    public E removeLast() {
        this.notifyModified();
        byte[] e = this.nativeRemoveLast(this.getNativeHandle());
        if (e == null) {
            throw new NoSuchElementException("List is empty");
        }
        return (E)this.serializer.fromBytes(e);
    }

    public void truncate(long newSize) {
        Preconditions.checkArgument((newSize >= 0L ? 1 : 0) != 0, (String)"New size must be non-negative: %s", (long)newSize);
        this.notifyModified();
        this.nativeTruncate(this.getNativeHandle(), newSize);
    }

    private static native long nativeCreate(String var0, long var1);

    private static native long nativeCreateInGroup(String var0, byte[] var1, long var2);

    private static native void nativeFree(long var0);

    @Override
    native void nativeAdd(long var1, byte[] var3);

    @Override
    native void nativeSet(long var1, long var3, byte[] var5);

    @Override
    native byte[] nativeGet(long var1, long var3);

    @Override
    native byte[] nativeGetLast(long var1);

    native byte[] nativeRemoveLast(long var1);

    native void nativeTruncate(long var1, long var3);

    @Override
    native void nativeClear(long var1);

    @Override
    native boolean nativeIsEmpty(long var1);

    @Override
    native long nativeSize(long var1);

    @Override
    native long nativeCreateIter(long var1);

    @Override
    native byte[] nativeIterNext(long var1);

    @Override
    native void nativeIterFree(long var1);

    static {
        LibraryLoader.load();
    }
}

