/*
 * Decompiled with CFR 0.152.
 */
package com.exonum.binding.core.storage.indices;

import com.exonum.binding.common.serialization.CheckingSerializerDecorator;
import com.exonum.binding.common.serialization.Serializer;
import com.exonum.binding.common.serialization.StandardSerializers;
import com.exonum.binding.core.proxy.Cleaner;
import com.exonum.binding.core.proxy.NativeHandle;
import com.exonum.binding.core.proxy.ProxyDestructor;
import com.exonum.binding.core.storage.database.View;
import com.exonum.binding.core.storage.indices.AbstractIndexProxy;
import com.exonum.binding.core.storage.indices.IndexAddress;
import com.exonum.binding.core.storage.indices.StorageIndex;
import com.exonum.binding.core.storage.indices.StorageIterators;
import com.exonum.binding.core.storage.indices.StoragePreconditions;
import com.exonum.binding.core.util.LibraryLoader;
import com.google.protobuf.MessageLite;
import java.util.Iterator;
import java.util.Spliterators;
import java.util.function.LongSupplier;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public final class KeySetIndexProxy<E>
extends AbstractIndexProxy
implements Iterable<E> {
    private static final int BASE_SPLITERATOR_CHARACTERISTICS = 272;
    private final CheckingSerializerDecorator<E> serializer;

    public static <E extends MessageLite> KeySetIndexProxy<E> newInstance(String name, View view, Class<E> keyType) {
        return KeySetIndexProxy.newInstance(name, view, StandardSerializers.protobuf(keyType));
    }

    public static <E> KeySetIndexProxy<E> newInstance(String name, View view, Serializer<E> serializer) {
        IndexAddress address = IndexAddress.valueOf(name);
        long viewNativeHandle = view.getViewNativeHandle();
        LongSupplier nativeSetConstructor = () -> KeySetIndexProxy.nativeCreate(name, viewNativeHandle);
        return KeySetIndexProxy.getOrCreate(address, view, serializer, nativeSetConstructor);
    }

    public static <E> KeySetIndexProxy<E> newInGroupUnsafe(String groupName, byte[] indexId, View view, Serializer<E> serializer) {
        IndexAddress address = IndexAddress.valueOf(groupName, indexId);
        long viewNativeHandle = view.getViewNativeHandle();
        LongSupplier nativeSetConstructor = () -> KeySetIndexProxy.nativeCreateInGroup(groupName, indexId, viewNativeHandle);
        return KeySetIndexProxy.getOrCreate(address, view, serializer, nativeSetConstructor);
    }

    private static <E> KeySetIndexProxy<E> getOrCreate(IndexAddress address, View view, Serializer<E> serializer, LongSupplier nativeSetConstructor) {
        return view.findOpenIndex(address).map(KeySetIndexProxy::checkCachedInstance).orElseGet(() -> KeySetIndexProxy.newKeySetProxy(address, view, serializer, nativeSetConstructor));
    }

    private static <E> KeySetIndexProxy<E> checkCachedInstance(StorageIndex cachedIndex) {
        StoragePreconditions.checkIndexType(cachedIndex, KeySetIndexProxy.class);
        return (KeySetIndexProxy)cachedIndex;
    }

    private static <E> KeySetIndexProxy<E> newKeySetProxy(IndexAddress address, View view, Serializer<E> serializer, LongSupplier nativeSetConstructor) {
        CheckingSerializerDecorator s = CheckingSerializerDecorator.from(serializer);
        NativeHandle setNativeHandle = KeySetIndexProxy.createNativeSet(view, nativeSetConstructor);
        KeySetIndexProxy<E> set = new KeySetIndexProxy<E>(setNativeHandle, address, view, s);
        view.registerIndex(set);
        return set;
    }

    private static NativeHandle createNativeSet(View view, LongSupplier nativeSetConstructor) {
        Cleaner cleaner = view.getCleaner();
        NativeHandle setNativeHandle = new NativeHandle(nativeSetConstructor.getAsLong());
        ProxyDestructor.newRegistered(cleaner, setNativeHandle, KeySetIndexProxy.class, KeySetIndexProxy::nativeFree);
        return setNativeHandle;
    }

    private KeySetIndexProxy(NativeHandle nativeHandle, IndexAddress address, View view, CheckingSerializerDecorator<E> serializer) {
        super(nativeHandle, address, view);
        this.serializer = serializer;
    }

    public void add(E e) {
        this.notifyModified();
        byte[] dbElement = this.serializer.toBytes(e);
        this.nativeAdd(this.getNativeHandle(), dbElement);
    }

    public void clear() {
        this.notifyModified();
        this.nativeClear(this.getNativeHandle());
    }

    public boolean contains(E e) {
        byte[] dbElement = this.serializer.toBytes(e);
        return this.nativeContains(this.getNativeHandle(), dbElement);
    }

    @Override
    public Iterator<E> iterator() {
        return StorageIterators.createIterator(this.nativeCreateIterator(this.getNativeHandle()), this::nativeIteratorNext, this::nativeIteratorFree, this.dbView, this.modCounter, arg_0 -> this.serializer.fromBytes(arg_0));
    }

    public Stream<E> stream() {
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(this.iterator(), this.streamCharacteristics()), false);
    }

    private int streamCharacteristics() {
        if (this.dbView.canModify()) {
            return 272;
        }
        return 1296;
    }

    public void remove(E e) {
        this.notifyModified();
        byte[] dbElement = this.serializer.toBytes(e);
        this.nativeRemove(this.getNativeHandle(), dbElement);
    }

    private static native long nativeCreate(String var0, long var1);

    private static native long nativeCreateInGroup(String var0, byte[] var1, long var2);

    private native void nativeAdd(long var1, byte[] var3);

    private native void nativeClear(long var1);

    private native boolean nativeContains(long var1, byte[] var3);

    private native long nativeCreateIterator(long var1);

    private native byte[] nativeIteratorNext(long var1);

    private native void nativeIteratorFree(long var1);

    private native void nativeRemove(long var1, byte[] var3);

    private static native void nativeFree(long var0);

    static {
        LibraryLoader.load();
    }
}

