/*
 * Decompiled with CFR 0.152.
 */
package com.exonum.binding.core.storage.database;

import com.exonum.binding.core.storage.indices.IndexAddress;
import com.exonum.binding.core.storage.indices.StorageIndex;
import com.google.common.base.Preconditions;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

class OpenIndexRegistry {
    private final Map<IndexAddress, StorageIndex> indexes = new HashMap<IndexAddress, StorageIndex>();

    OpenIndexRegistry() {
    }

    void registerIndex(StorageIndex index) {
        IndexAddress address = index.getAddress();
        StorageIndex present = this.indexes.putIfAbsent(address, index);
        Preconditions.checkArgument((present == null ? 1 : 0) != 0, (String)"Cannot register index (%s): the address (%s) is already associated with index (%s): ", (Object)index, (Object)address, (Object)present);
    }

    Optional<StorageIndex> findIndex(IndexAddress address) {
        return Optional.ofNullable(this.indexes.get(address));
    }
}

