/*
 * Decompiled with CFR 0.152.
 */
package com.exonum.binding.core.storage.database;

import com.exonum.binding.core.proxy.Cleaner;
import com.exonum.binding.core.proxy.CloseFailuresException;
import com.exonum.binding.core.proxy.NativeHandle;
import com.exonum.binding.core.proxy.ProxyDestructor;
import com.exonum.binding.core.storage.database.View;
import com.exonum.binding.core.storage.database.Views;
import com.google.common.base.Preconditions;

public final class Fork
extends View {
    private final ProxyDestructor destructor;

    public static Fork newInstance(long nativeHandle, Cleaner cleaner) {
        return Fork.newInstance(nativeHandle, true, cleaner);
    }

    public static Fork newInstance(long nativeHandle, boolean owningHandle, Cleaner cleaner) {
        Preconditions.checkNotNull((Object)cleaner, (Object)"cleaner");
        NativeHandle h = new NativeHandle(nativeHandle);
        ProxyDestructor destructor = ProxyDestructor.newRegistered(cleaner, h, Fork.class, nh -> {
            if (owningHandle) {
                Views.nativeFree(nh);
            }
        });
        Cleaner forkCleaner = new Cleaner();
        cleaner.add(forkCleaner::close);
        return new Fork(h, destructor, forkCleaner);
    }

    private Fork(NativeHandle nativeHandle, ProxyDestructor destructor, Cleaner forkCleaner) {
        super(nativeHandle, forkCleaner, true);
        this.destructor = destructor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    NativeHandle intoPatch() {
        Preconditions.checkState((boolean)Fork.nativeCanConvertIntoPatch(this.getNativeHandle()), (Object)"This fork cannot be converted into patch");
        try {
            this.getCleaner().close();
        }
        catch (CloseFailuresException e) {
            this.destructor.clean();
            throw new IllegalStateException("intoPatch aborted because some dependent resources did not close properly", e);
        }
        try {
            this.destructor.cancel();
            long patchNativeHandle = Fork.nativeIntoPatch(this.getNativeHandle());
            NativeHandle nativeHandle = new NativeHandle(patchNativeHandle);
            return nativeHandle;
        }
        finally {
            this.nativeHandle.close();
        }
    }

    private static native boolean nativeCanConvertIntoPatch(long var0);

    private static native long nativeIntoPatch(long var0);
}

