/*
 * Decompiled with CFR 0.152.
 */
package com.exonum.binding.core.runtime;

import com.exonum.binding.core.runtime.LoadedServiceDefinition;
import com.exonum.binding.core.runtime.ServiceId;
import com.exonum.binding.core.runtime.ServiceLoader;
import com.exonum.binding.core.runtime.ServiceLoadingException;
import com.exonum.binding.core.service.ServiceModule;
import com.exonum.binding.core.service.adapters.UserServiceAdapter;
import com.exonum.binding.core.transport.Server;
import com.google.common.base.Preconditions;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.Singleton;
import com.google.inject.name.Named;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.function.Supplier;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Singleton
public final class ServiceRuntime {
    private static final Logger logger = LogManager.getLogger(ServiceRuntime.class);
    private final Injector frameworkInjector;
    private final ServiceLoader serviceLoader;
    private final Object lock = new Object();

    @Inject
    public ServiceRuntime(Injector frameworkInjector, ServiceLoader serviceLoader, Server server, @Named(value="Service web server port") int serverPort) {
        this.frameworkInjector = (Injector)Preconditions.checkNotNull((Object)frameworkInjector);
        this.serviceLoader = (ServiceLoader)Preconditions.checkNotNull((Object)serviceLoader);
        this.checkServerIsSingleton(server, frameworkInjector);
        server.start(serverPort);
    }

    private void checkServerIsSingleton(Server s1, Injector frameworkInjector) {
        Server s2 = (Server)frameworkInjector.getInstance(Server.class);
        Preconditions.checkArgument((boolean)s1.equals(s2), (String)"%s is not configured as singleton: s1=%s, s2=%s", Server.class, (Object)s1, (Object)s2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String loadArtifact(String serviceArtifactPath) throws ServiceLoadingException {
        Path serviceArtifactLocation = Paths.get(serviceArtifactPath, new String[0]);
        try {
            ServiceId serviceId;
            Object object = this.lock;
            synchronized (object) {
                LoadedServiceDefinition loadedServiceDefinition = this.serviceLoader.loadService(serviceArtifactLocation);
                serviceId = loadedServiceDefinition.getId();
            }
            logger.debug("Loaded an artifact ({}) from {}", (Object)serviceId, (Object)serviceArtifactPath);
            return serviceId.toString();
        }
        catch (Throwable e) {
            logger.error("Failed to load an artifact from {}", (Object)serviceArtifactPath, (Object)e);
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UserServiceAdapter createService(String artifactId) {
        try {
            UserServiceAdapter service;
            ServiceId serviceId = ServiceId.parseFrom(artifactId);
            Object object = this.lock;
            synchronized (object) {
                LoadedServiceDefinition serviceDefinition = this.serviceLoader.findService(serviceId).orElseThrow(() -> new IllegalArgumentException("Unknown artifactId: " + artifactId));
                Supplier<ServiceModule> serviceModuleSupplier = serviceDefinition.getModuleSupplier();
                Module serviceModule = serviceModuleSupplier.get();
                Injector serviceInjector = this.frameworkInjector.createChildInjector(new Module[]{serviceModule});
                service = (UserServiceAdapter)serviceInjector.getInstance(UserServiceAdapter.class);
            }
            logger.info("Created {} service (id={}, artifactId={})", (Object)service.getName(), (Object)service.getId(), (Object)artifactId);
            return service;
        }
        catch (Throwable e) {
            logger.error("Failed to create a service {} instance", (Object)artifactId, (Object)e);
            throw e;
        }
    }
}

