/*
 * Decompiled with CFR 0.152.
 */
package com.exonum.binding.core.runtime;

import com.exonum.binding.core.runtime.AutoValue_ServiceId;
import com.google.auto.value.AutoValue;
import com.google.common.base.Preconditions;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

@AutoValue
public abstract class ServiceId {
    private static final String DELIMITER = ":";
    private static final Pattern FORBIDDEN_CHARS_PATTERN = Pattern.compile("[\\s:]");
    private static final int KEEP_EMPTY = -1;

    public abstract String getGroupId();

    public abstract String getArtifactId();

    public abstract String getVersion();

    public static ServiceId parseFrom(String serviceId) {
        String[] coordinates = serviceId.split(DELIMITER, -1);
        Preconditions.checkArgument((coordinates.length == 3 ? 1 : 0) != 0, (String)"Invalid serviceId (%s), must have 'groupId:artifactId:version' format", (Object)serviceId);
        String groupId = coordinates[0];
        String artifactId = coordinates[1];
        String version = coordinates[2];
        return ServiceId.of(groupId, artifactId, version);
    }

    public static ServiceId of(String groupId, String artifactId, String version) {
        return new AutoValue_ServiceId(ServiceId.checkNoForbiddenChars(groupId), ServiceId.checkNoForbiddenChars(artifactId), ServiceId.checkNoForbiddenChars(version));
    }

    private static String checkNoForbiddenChars(String s) {
        Matcher matcher = FORBIDDEN_CHARS_PATTERN.matcher(s);
        if (matcher.find()) {
            throw new IllegalArgumentException(String.format("'%s' must not have any forbidden characters, but there is at index %d", s, matcher.start()));
        }
        return s;
    }

    public final String toString() {
        return this.getGroupId() + DELIMITER + this.getArtifactId() + DELIMITER + this.getVersion();
    }
}

