/*
 * Decompiled with CFR 0.152.
 */
package com.exonum.binding.core.proxy;

import com.exonum.binding.core.proxy.CancellableCleanAction;
import com.exonum.binding.core.proxy.Cleaner;
import com.exonum.binding.core.proxy.NativeHandle;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.Optional;
import java.util.function.LongConsumer;

public final class ProxyDestructor
implements CancellableCleanAction<Class<?>> {
    private final NativeHandle nativeHandle;
    private final LongConsumer cleanFunction;
    private final Class<?> proxyClass;
    private boolean destroyed;
    private boolean cancelled;

    @CanIgnoreReturnValue
    public static ProxyDestructor newRegistered(Cleaner cleaner, NativeHandle nativeHandle, Class<?> proxyClass, LongConsumer destructorFunction) {
        ProxyDestructor d = new ProxyDestructor(nativeHandle, proxyClass, destructorFunction);
        cleaner.add(d);
        return d;
    }

    public ProxyDestructor(NativeHandle nativeHandle, Class<?> proxyClass, LongConsumer destructorFunction) {
        this.nativeHandle = (NativeHandle)Preconditions.checkNotNull((Object)nativeHandle);
        this.cleanFunction = (LongConsumer)Preconditions.checkNotNull((Object)destructorFunction);
        this.proxyClass = (Class)Preconditions.checkNotNull(proxyClass);
        this.destroyed = false;
        this.cancelled = false;
    }

    @Override
    public void clean() {
        if (this.destroyed || this.cancelled) {
            return;
        }
        this.destroyed = true;
        if (!this.nativeHandle.isValid()) {
            return;
        }
        long handle = this.nativeHandle.get();
        this.nativeHandle.close();
        this.cleanFunction.accept(handle);
    }

    @Override
    public Optional<Class<?>> resourceType() {
        return Optional.of(this.proxyClass);
    }

    @Override
    public void cancel() {
        this.cancelled = true;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("nativeHandle", (Object)this.nativeHandle).add("proxyClass", this.proxyClass).add("destroyed", this.destroyed).add("cancelled", this.cancelled).toString();
    }
}

