/*
 * Decompiled with CFR 0.152.
 */
package com.exonum.binding.core.blockchain;

import com.exonum.binding.common.hash.HashCode;
import com.exonum.binding.core.blockchain.AutoValue_Block;
import com.exonum.binding.core.blockchain.Block;

abstract class $AutoValue_Block
extends Block {
    private final HashCode blockHash;
    private final int proposerId;
    private final long height;
    private final int numTransactions;
    private final HashCode previousBlockHash;
    private final HashCode txRootHash;
    private final HashCode stateHash;

    $AutoValue_Block(HashCode blockHash, int proposerId, long height, int numTransactions, HashCode previousBlockHash, HashCode txRootHash, HashCode stateHash) {
        if (blockHash == null) {
            throw new NullPointerException("Null blockHash");
        }
        this.blockHash = blockHash;
        this.proposerId = proposerId;
        this.height = height;
        this.numTransactions = numTransactions;
        if (previousBlockHash == null) {
            throw new NullPointerException("Null previousBlockHash");
        }
        this.previousBlockHash = previousBlockHash;
        if (txRootHash == null) {
            throw new NullPointerException("Null txRootHash");
        }
        this.txRootHash = txRootHash;
        if (stateHash == null) {
            throw new NullPointerException("Null stateHash");
        }
        this.stateHash = stateHash;
    }

    @Override
    public HashCode getBlockHash() {
        return this.blockHash;
    }

    @Override
    public int getProposerId() {
        return this.proposerId;
    }

    @Override
    public long getHeight() {
        return this.height;
    }

    @Override
    public int getNumTransactions() {
        return this.numTransactions;
    }

    @Override
    public HashCode getPreviousBlockHash() {
        return this.previousBlockHash;
    }

    @Override
    public HashCode getTxRootHash() {
        return this.txRootHash;
    }

    @Override
    public HashCode getStateHash() {
        return this.stateHash;
    }

    public String toString() {
        return "Block{blockHash=" + this.blockHash + ", proposerId=" + this.proposerId + ", height=" + this.height + ", numTransactions=" + this.numTransactions + ", previousBlockHash=" + this.previousBlockHash + ", txRootHash=" + this.txRootHash + ", stateHash=" + this.stateHash + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof Block) {
            Block that = (Block)o;
            return this.blockHash.equals((Object)that.getBlockHash()) && this.proposerId == that.getProposerId() && this.height == that.getHeight() && this.numTransactions == that.getNumTransactions() && this.previousBlockHash.equals((Object)that.getPreviousBlockHash()) && this.txRootHash.equals((Object)that.getTxRootHash()) && this.stateHash.equals((Object)that.getStateHash());
        }
        return false;
    }

    static final class Builder
    extends Block.Builder {
        private HashCode blockHash;
        private Integer proposerId;
        private Long height;
        private Integer numTransactions;
        private HashCode previousBlockHash;
        private HashCode txRootHash;
        private HashCode stateHash;

        Builder() {
        }

        @Override
        public Block.Builder blockHash(HashCode blockHash) {
            if (blockHash == null) {
                throw new NullPointerException("Null blockHash");
            }
            this.blockHash = blockHash;
            return this;
        }

        @Override
        public Block.Builder proposerId(int proposerId) {
            this.proposerId = proposerId;
            return this;
        }

        @Override
        public Block.Builder height(long height) {
            this.height = height;
            return this;
        }

        @Override
        public Block.Builder numTransactions(int numTransactions) {
            this.numTransactions = numTransactions;
            return this;
        }

        @Override
        public Block.Builder previousBlockHash(HashCode previousBlockHash) {
            if (previousBlockHash == null) {
                throw new NullPointerException("Null previousBlockHash");
            }
            this.previousBlockHash = previousBlockHash;
            return this;
        }

        @Override
        public Block.Builder txRootHash(HashCode txRootHash) {
            if (txRootHash == null) {
                throw new NullPointerException("Null txRootHash");
            }
            this.txRootHash = txRootHash;
            return this;
        }

        @Override
        public Block.Builder stateHash(HashCode stateHash) {
            if (stateHash == null) {
                throw new NullPointerException("Null stateHash");
            }
            this.stateHash = stateHash;
            return this;
        }

        @Override
        Block autoBuild() {
            String missing = "";
            if (this.blockHash == null) {
                missing = missing + " blockHash";
            }
            if (this.proposerId == null) {
                missing = missing + " proposerId";
            }
            if (this.height == null) {
                missing = missing + " height";
            }
            if (this.numTransactions == null) {
                missing = missing + " numTransactions";
            }
            if (this.previousBlockHash == null) {
                missing = missing + " previousBlockHash";
            }
            if (this.txRootHash == null) {
                missing = missing + " txRootHash";
            }
            if (this.stateHash == null) {
                missing = missing + " stateHash";
            }
            if (!missing.isEmpty()) {
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new AutoValue_Block(this.blockHash, this.proposerId, this.height, this.numTransactions, this.previousBlockHash, this.txRootHash, this.stateHash);
        }
    }
}

