/*
 * Decompiled with CFR 0.152.
 */
package com.exonum.binding.core.util;

import com.exonum.binding.core.util.OsInfo;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class LibraryLoader {
    private static final String BINDING_LIB_NAME = "java_bindings";
    private static final String JAVA_LIBRARY_PATH_PROPERTY = "java.library.path";
    private static final String DYNAMIC_LIBRARIES_ENV_VAR_WINDOWS = "PATH";
    private static final String DYNAMIC_LIBRARIES_ENV_VAR_UNIX = "LD_LIBRARY_PATH";
    private static final String JAVA_BINDING_VERSION = "0.7.0";
    private static final Logger logger = LogManager.getLogger(LibraryLoader.class);
    private static final LibraryLoader INSTANCE = new LibraryLoader("0.7.0");
    private final String expectedLibVersion;
    private boolean loaded;

    private LibraryLoader(String libraryVersion) {
        this.expectedLibVersion = libraryVersion;
        this.loaded = false;
    }

    public static void load() {
        INSTANCE.loadOnce();
    }

    private synchronized void loadOnce() {
        if (this.loaded) {
            return;
        }
        try {
            LibraryLoader.loadLibrary();
            this.checkLibraryVersion();
        }
        finally {
            this.loaded = true;
        }
    }

    private static void loadLibrary() {
        try {
            System.loadLibrary(BINDING_LIB_NAME);
        }
        catch (UnsatisfiedLinkError e) {
            String message = String.format("Failed to load '%s' library: %s.%n%s", BINDING_LIB_NAME, e.getMessage(), LibraryLoader.extraLibLoadErrorInfo());
            logger.fatal(message, (Throwable)e);
            throw new LinkageError(message, e);
        }
    }

    private static String extraLibLoadErrorInfo() {
        String javaLibPath = System.getProperty(JAVA_LIBRARY_PATH_PROPERTY);
        if (LibraryLoader.runningUnitTests()) {
            return String.format("Check that %s system property includes a path to '${EXONUM_HOME}/lib/native' directory%ncontaining %s library, where 'EXONUM_HOME' denotes the Exonum Java app installation directory.%nThe code launching tests must usually set this property explicitly, see https://exonum.com/doc/version/0.11/get-started/java-binding/#testing", JAVA_LIBRARY_PATH_PROPERTY, BINDING_LIB_NAME);
        }
        String dynamicLibVar = LibraryLoader.dynamicLibrariesEnvVar();
        String dynamicLibValue = System.getenv(dynamicLibVar);
        return String.format("Unknown error: please submit an issue including this error message.%n%s=%s%n%s=%s", JAVA_LIBRARY_PATH_PROPERTY, javaLibPath, dynamicLibVar, dynamicLibValue);
    }

    private static boolean runningUnitTests() {
        try {
            Class.forName("org.junit.jupiter.api.Test");
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    private static String dynamicLibrariesEnvVar() {
        if (OsInfo.isWindows()) {
            return DYNAMIC_LIBRARIES_ENV_VAR_WINDOWS;
        }
        return DYNAMIC_LIBRARIES_ENV_VAR_UNIX;
    }

    private void checkLibraryVersion() {
        String nativeLibVersion = LibraryLoader.nativeGetLibraryVersion();
        if (!this.expectedLibVersion.equals(nativeLibVersion)) {
            String message = String.format("Mismatch between versions of Java library and native '%s' library:%n  Java library version:   %s%n  Native library version: %s%nCheck that the version of 'exonum-java-binding-core' matches the version of the installed 'Exonum Java' application.%nSee https://exonum.com/doc/version/0.11/get-started/java-binding/#installation", BINDING_LIB_NAME, this.expectedLibVersion, nativeLibVersion);
            logger.fatal(message);
            throw new LinkageError(message);
        }
    }

    private static native String nativeGetLibraryVersion();
}

