/*
 * Decompiled with CFR 0.152.
 */
package com.exonum.binding.core.transport;

import com.exonum.binding.core.transport.Server;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.http.HttpServer;
import io.vertx.ext.web.Router;
import java.util.OptionalInt;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

final class VertxServer
implements Server {
    private static final Logger logger = LogManager.getLogger(VertxServer.class);
    private final Vertx vertx;
    private final HttpServer server;
    private final Router rootRouter;
    private final Object lock = new Object();
    private State state;
    private CompletableFuture<Void> stopFuture;

    VertxServer() {
        this.vertx = Vertx.vertx();
        this.rootRouter = Router.router((Vertx)this.vertx);
        this.server = this.vertx.createHttpServer().requestHandler((Handler)this.rootRouter);
        this.state = State.IDLE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Router createRouter() {
        Object object = this.lock;
        synchronized (object) {
            this.checkNotStopped();
            return Router.router((Vertx)this.vertx);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void mountSubRouter(String mountPoint, Router subRouter) {
        Object object = this.lock;
        synchronized (object) {
            this.checkNotStopped();
            this.rootRouter.mountSubRouter(mountPoint, subRouter);
        }
    }

    private void checkNotStopped() {
        if (this.state == State.STOPPED) {
            throw new IllegalStateException("Server is stopped");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start(int port) {
        Object object = this.lock;
        synchronized (object) {
            if (this.state != State.IDLE) {
                throw new IllegalStateException("Cannot start a server when its state is " + (Object)((Object)this.state));
            }
            this.state = State.STARTED;
            this.server.listen(port);
            logger.info("Java server is listening at port {}", (Object)this.server.actualPort());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OptionalInt getActualPort() {
        Object object = this.lock;
        synchronized (object) {
            if (this.state == State.STARTED) {
                return OptionalInt.of(this.server.actualPort());
            }
            return OptionalInt.empty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompletableFuture<Void> stop() {
        Object object = this.lock;
        synchronized (object) {
            if (this.stopFuture != null) {
                return this.stopFuture;
            }
            this.state = State.STOPPED;
            this.stopFuture = new CompletableFuture();
            logger.info("Requesting to stop");
            this.vertx.close(r -> this.notifyVertxStopped());
            return this.stopFuture;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyVertxStopped() {
        logger.info("Stopped");
        Object object = this.lock;
        synchronized (object) {
            this.rootRouter.clear();
            this.stopFuture.complete(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        Object object = this.lock;
        synchronized (object) {
            return "Server{port=" + this.server.actualPort() + ", state=" + (Object)((Object)this.state) + ", stopFuture=" + this.stopFuture + '}';
        }
    }

    public static void main(String[] args) {
        VertxServer server = new VertxServer();
        Router router = server.createRouter();
        router.get("/foo").handler(rc -> rc.response().end("Hi from /s1/foo"));
        router.get("/slow-handler").handler(rc -> {
            try {
                Thread.sleep(8000L);
                rc.response().end("Hi from a terribly slow handler.");
            }
            catch (InterruptedException e) {
                System.err.printf("The thread (%s) has been interrupted:%n", Thread.currentThread().toString());
                e.printStackTrace();
                Thread.currentThread().interrupt();
            }
        });
        server.mountSubRouter("/s1", router);
        server.start(8080);
        System.out.println("Started: " + server);
        ScheduledThreadPoolExecutor service = new ScheduledThreadPoolExecutor(1);
        service.schedule(() -> {
            System.out.println("Requesting to stop");
            CompletableFuture<Void> sf = server.stop();
            sf.whenComplete((result, throwable) -> {
                System.out.println("Stopped, stopping the executor");
                service.shutdown();
            });
            System.out.println("\u2026");
        }, 5L, TimeUnit.SECONDS);
    }

    static enum State {
        IDLE,
        STARTED,
        STOPPED;

    }
}

