/*
 * Decompiled with CFR 0.152.
 */
package com.exonum.binding.core.transaction;

import com.exonum.binding.common.crypto.PublicKey;
import com.exonum.binding.common.hash.HashCode;
import com.exonum.binding.core.storage.database.Fork;
import com.exonum.binding.core.transaction.InternalTransactionContext;

public interface TransactionContext {
    public Fork getFork();

    public HashCode getTransactionMessageHash();

    public PublicKey getAuthorPk();

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Fork fork;
        private HashCode hash;
        private PublicKey authorPk;

        public Builder fork(Fork fork) {
            this.fork = fork;
            return this;
        }

        public Builder txMessageHash(HashCode hash) {
            this.hash = hash;
            return this;
        }

        public Builder authorPk(PublicKey authorPk) {
            this.authorPk = authorPk;
            return this;
        }

        public TransactionContext build() {
            return new InternalTransactionContext(this.fork, this.hash, this.authorPk);
        }

        private Builder() {
        }
    }
}

