/*
 * Decompiled with CFR 0.152.
 */
package com.exonum.binding.core.storage.indices;

import com.exonum.binding.common.serialization.CheckingSerializerDecorator;
import com.exonum.binding.common.serialization.Serializer;
import com.exonum.binding.common.serialization.StandardSerializers;
import com.exonum.binding.core.proxy.Cleaner;
import com.exonum.binding.core.proxy.NativeHandle;
import com.exonum.binding.core.proxy.ProxyDestructor;
import com.exonum.binding.core.storage.database.View;
import com.exonum.binding.core.storage.indices.AbstractIndexProxy;
import com.exonum.binding.core.storage.indices.StoragePreconditions;
import com.exonum.binding.core.util.LibraryLoader;
import com.google.protobuf.MessageLite;
import java.util.NoSuchElementException;
import java.util.Optional;

public final class EntryIndexProxy<T>
extends AbstractIndexProxy {
    private final CheckingSerializerDecorator<T> serializer;

    public static <E extends MessageLite> EntryIndexProxy<E> newInstance(String name, View view, Class<E> elementType) {
        return EntryIndexProxy.newInstance(name, view, StandardSerializers.protobuf(elementType));
    }

    public static <E> EntryIndexProxy<E> newInstance(String name, View view, Serializer<E> serializer) {
        StoragePreconditions.checkIndexName(name);
        CheckingSerializerDecorator s = CheckingSerializerDecorator.from(serializer);
        NativeHandle entryNativeHandle = EntryIndexProxy.createNativeEntry(name, view);
        return new EntryIndexProxy(entryNativeHandle, name, view, s);
    }

    private static NativeHandle createNativeEntry(String name, View view) {
        long viewNativeHandle = view.getViewNativeHandle();
        NativeHandle entryNativeHandle = new NativeHandle(EntryIndexProxy.nativeCreate(name, viewNativeHandle));
        Cleaner cleaner = view.getCleaner();
        ProxyDestructor.newRegistered(cleaner, entryNativeHandle, EntryIndexProxy.class, EntryIndexProxy::nativeFree);
        return entryNativeHandle;
    }

    private EntryIndexProxy(NativeHandle nativeHandle, String name, View view, CheckingSerializerDecorator<T> serializer) {
        super(nativeHandle, name, view);
        this.serializer = serializer;
    }

    public void set(T value) {
        this.notifyModified();
        byte[] valueBytes = this.serializer.toBytes(value);
        this.nativeSet(this.getNativeHandle(), valueBytes);
    }

    public boolean isPresent() {
        return this.nativeIsPresent(this.getNativeHandle());
    }

    public T get() {
        byte[] value = this.nativeGet(this.getNativeHandle());
        if (value == null) {
            throw new NoSuchElementException("No value in this entry");
        }
        return (T)this.serializer.fromBytes(value);
    }

    public void remove() {
        this.notifyModified();
        this.nativeRemove(this.getNativeHandle());
    }

    public Optional<T> toOptional() {
        if (this.isPresent()) {
            return Optional.of(this.get());
        }
        return Optional.empty();
    }

    private static native long nativeCreate(String var0, long var1);

    private native void nativeSet(long var1, byte[] var3);

    private native boolean nativeIsPresent(long var1);

    private native byte[] nativeGet(long var1);

    private native byte[] nativeGetHash(long var1);

    private native void nativeRemove(long var1);

    private static native void nativeFree(long var0);

    static {
        LibraryLoader.load();
    }
}

