/*
 * Decompiled with CFR 0.152.
 */
package com.exonum.binding.core.storage.indices;

import com.exonum.binding.core.proxy.AbstractNativeProxy;
import com.exonum.binding.core.proxy.NativeHandle;
import com.exonum.binding.core.storage.database.ModificationCounter;
import com.exonum.binding.core.storage.database.View;
import com.exonum.binding.core.storage.indices.StorageIndex;
import com.exonum.binding.core.storage.indices.StoragePreconditions;
import com.google.common.base.Preconditions;

abstract class AbstractIndexProxy
extends AbstractNativeProxy
implements StorageIndex {
    final View dbView;
    final ModificationCounter modCounter;
    private final String name;

    AbstractIndexProxy(NativeHandle nativeHandle, String name, View view) {
        super(nativeHandle);
        this.name = StoragePreconditions.checkIndexName(name);
        this.dbView = (View)Preconditions.checkNotNull((Object)view);
        this.modCounter = view.getModificationCounter();
    }

    @Override
    public final String getName() {
        return this.name;
    }

    void notifyModified() {
        this.checkCanModify();
        this.modCounter.notifyModified();
    }

    private void checkCanModify() {
        if (!this.dbView.canModify()) {
            throw new UnsupportedOperationException("Cannot modify the view: " + this.dbView + "\nUse a Fork to modify any collection.");
        }
    }

    public String toString() {
        return this.name + ": " + this.getClass().getName();
    }
}

