/*
 * Decompiled with CFR 0.152.
 */
package com.exonum.binding.core.service;

import com.exonum.binding.common.crypto.PublicKey;
import com.exonum.binding.common.hash.HashCode;
import com.exonum.binding.core.proxy.Cleaner;
import com.exonum.binding.core.proxy.CloseFailuresException;
import com.exonum.binding.core.service.Node;
import com.exonum.binding.core.storage.database.MemoryDb;
import com.exonum.binding.core.storage.database.Snapshot;
import com.exonum.binding.core.transaction.RawTransaction;
import com.google.common.base.Preconditions;
import java.util.function.Function;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class NodeFake
implements Node {
    private static final Logger logger = LogManager.getLogger(NodeFake.class);
    private final MemoryDb database;
    private final PublicKey publicKey;

    public NodeFake(MemoryDb database) {
        this(database, PublicKey.fromBytes((byte[])new byte[32]));
    }

    public NodeFake(MemoryDb database, PublicKey publicKey) {
        this.database = (MemoryDb)Preconditions.checkNotNull((Object)database);
        this.publicKey = publicKey;
    }

    @Override
    public HashCode submitTransaction(RawTransaction transaction) {
        Preconditions.checkNotNull((Object)transaction);
        return HashCode.fromBytes((byte[])new byte[32]);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public <ResultT> ResultT withSnapshot(Function<Snapshot, ResultT> snapshotFunction) {
        try (Cleaner cleaner = new Cleaner("NodeFake#withSnapshot");){
            Snapshot snapshot = this.database.createSnapshot(cleaner);
            ResultT ResultT = snapshotFunction.apply(snapshot);
            return ResultT;
        }
        catch (CloseFailuresException e) {
            logger.error((Object)e);
            throw new RuntimeException(e);
        }
    }

    @Override
    public PublicKey getPublicKey() {
        return this.publicKey;
    }

    public MemoryDb getDatabase() {
        return this.database;
    }
}

