/*
 * Decompiled with CFR 0.152.
 */
package com.exonum.binding.storage.indices;

import com.exonum.binding.common.collect.MapEntry;
import com.exonum.binding.common.serialization.Serializer;
import com.exonum.binding.storage.indices.StoragePreconditions;

final class MapEntryInternal {
    final byte[] key;
    final byte[] value;

    MapEntryInternal(byte[] key, byte[] value) {
        this.key = StoragePreconditions.checkStorageKey(key);
        this.value = StoragePreconditions.checkStorageValue(value);
    }

    <V, K> MapEntry<K, V> toMapEntry(MapEntryInternal entry, Serializer<K> keySerializer, Serializer<V> valueSerializer) {
        Object key = keySerializer.fromBytes(entry.key);
        Object value = valueSerializer.fromBytes(entry.value);
        return MapEntry.valueOf((Object)key, (Object)value);
    }
}

