/*
 * Decompiled with CFR 0.152.
 */
package com.exonum.binding.storage.indices;

import com.exonum.binding.storage.database.ModificationCounter;
import com.exonum.binding.storage.indices.ListIndex;
import com.exonum.binding.storage.indices.StoragePreconditions;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.util.ConcurrentModificationException;
import java.util.Spliterator;
import java.util.function.Consumer;

class ListSpliterator<ElementT>
implements Spliterator<ElementT> {
    private static final int ANY_CHARACTERISTICS = 16720;
    @VisibleForTesting
    static final int MIN_SPLITTABLE_SIZE = 2;
    private final ListIndex<ElementT> list;
    private long nextIndex;
    private long fence;
    private final ModificationCounter counter;
    private final int characteristics;
    private Integer initialCounterValue;

    ListSpliterator(ListIndex<ElementT> list, ModificationCounter counter, boolean immutable) {
        this(list, counter, immutable, 0L, 0L, null);
    }

    private ListSpliterator(ListIndex<ElementT> list, ModificationCounter counter, boolean immutable, long nextIndex, long fence, Integer initialCounterValue) {
        this.list = list;
        Preconditions.checkArgument((0L <= fence ? 1 : 0) != 0, (Object)"fence (%s) must be non-negative");
        StoragePreconditions.checkPositionIndex(nextIndex, fence);
        this.nextIndex = nextIndex;
        this.fence = fence;
        this.counter = counter;
        this.characteristics = immutable ? 17744 : 16720;
        this.initialCounterValue = initialCounterValue;
    }

    @Override
    public boolean tryAdvance(Consumer<? super ElementT> action) {
        this.bindOrCheckModifications();
        if (this.nextIndex < this.fence) {
            ElementT nextElement = this.list.get(this.nextIndex);
            action.accept(nextElement);
            ++this.nextIndex;
            return true;
        }
        return false;
    }

    @Override
    public Spliterator<ElementT> trySplit() {
        this.bindOrCheckModifications();
        if (this.estimateSize() < 2L) {
            return null;
        }
        long mid = this.nextIndex + (this.fence - this.nextIndex) / 2L;
        ListSpliterator<ElementT> prefix = new ListSpliterator<ElementT>(this.list, this.counter, this.hasCharacteristics(1024), this.nextIndex, mid, this.initialCounterValue);
        this.nextIndex = mid;
        return prefix;
    }

    @Override
    public long estimateSize() {
        this.bindOrCheckModifications();
        return this.fence - this.nextIndex;
    }

    @Override
    public int characteristics() {
        return this.characteristics;
    }

    private void bindOrCheckModifications() {
        if (this.initialCounterValue == null) {
            this.nextIndex = 0L;
            this.fence = this.list.size();
            this.initialCounterValue = this.counter.getCurrentValue();
            return;
        }
        if (this.counter.isModifiedSince(this.initialCounterValue)) {
            throw new ConcurrentModificationException("The source (" + this.list + ") has been modified since the bind-time");
        }
    }
}

