/*
 * Decompiled with CFR 0.152.
 */
package com.exonum.binding.service.adapters;

import com.exonum.binding.common.hash.HashCode;
import com.exonum.binding.proxy.Cleaner;
import com.exonum.binding.proxy.CloseFailuresException;
import com.exonum.binding.service.BlockCommittedEvent;
import com.exonum.binding.service.BlockCommittedEventImpl;
import com.exonum.binding.service.NodeProxy;
import com.exonum.binding.service.Service;
import com.exonum.binding.service.adapters.UserTransactionAdapter;
import com.exonum.binding.service.adapters.ViewFactory;
import com.exonum.binding.storage.database.Fork;
import com.exonum.binding.storage.database.Snapshot;
import com.exonum.binding.transaction.RawTransaction;
import com.exonum.binding.transaction.Transaction;
import com.exonum.binding.transport.Server;
import com.google.common.base.Preconditions;
import com.google.inject.Inject;
import io.vertx.ext.web.Router;
import java.util.List;
import java.util.OptionalInt;
import javax.annotation.Nullable;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class UserServiceAdapter {
    private static final Logger logger = LogManager.getLogger(UserServiceAdapter.class);
    private static final String API_ROOT_PATH = "/api/services";
    private final Service service;
    private final Server server;
    private final ViewFactory viewFactory;
    @Nullable
    private NodeProxy node;

    @Inject
    public UserServiceAdapter(Service service, Server server, ViewFactory viewFactory) {
        this.service = (Service)Preconditions.checkNotNull((Object)service, (Object)"service");
        this.server = (Server)Preconditions.checkNotNull((Object)server, (Object)"server");
        this.viewFactory = (ViewFactory)Preconditions.checkNotNull((Object)viewFactory, (Object)"viewFactory");
    }

    public short getId() {
        return this.service.getId();
    }

    public String getName() {
        return this.service.getName();
    }

    public Service getService() {
        return this.service;
    }

    public UserTransactionAdapter convertTransaction(short transactionId, byte[] payload) {
        try {
            Preconditions.checkNotNull((Object)payload);
            RawTransaction rawTransaction = RawTransaction.newBuilder().serviceId(this.service.getId()).transactionId(transactionId).payload(payload).build();
            Transaction transaction = this.service.convertToTransaction(rawTransaction);
            Preconditions.checkNotNull((Object)transaction, (String)"Invalid service implementation: Service#convertToTransaction must never return null.\nThrow an exception if your service does not recognize this message id (%s)", (int)transactionId);
            return new UserTransactionAdapter(transaction, this.viewFactory);
        }
        catch (IllegalArgumentException | NullPointerException e) {
            logger.warn("Failed to convert transaction {} for service {}", (Object)transactionId, (Object)this.service.getId(), (Object)e);
            throw e;
        }
        catch (Exception e) {
            logger.error("Unexpected exception occurs at convert transaction {} for service {}", (Object)transactionId, (Object)this.service.getId(), (Object)e);
            throw e;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public byte[][] getStateHashes(long snapshotHandle) {
        assert (snapshotHandle != 0L);
        try (Cleaner cleaner = new Cleaner("UserServiceAdapter#getStateHashes");){
            Snapshot snapshot = this.viewFactory.createSnapshot(snapshotHandle, cleaner);
            List<HashCode> stateHashes = this.service.getStateHashes(snapshot);
            byte[][] byArray = (byte[][])stateHashes.stream().map(HashCode::asBytes).toArray(x$0 -> new byte[x$0][]);
            return byArray;
        }
        catch (CloseFailuresException e) {
            logger.error("Failed to close some resources at getStateHashes", (Throwable)e);
            throw new RuntimeException(e);
        }
        catch (Exception e) {
            logger.error("Unexpected exception occurs at getStateHashes", (Throwable)e);
            throw e;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public String initialize(long forkHandle) {
        assert (forkHandle != 0L);
        try (Cleaner cleaner = new Cleaner("UserServiceAdapter#initialize");){
            Fork fork = this.viewFactory.createFork(forkHandle, cleaner);
            String string = this.service.initialize(fork).orElse(null);
            return string;
        }
        catch (CloseFailuresException e) {
            logger.error("Failed to close some resources at initialize", (Throwable)e);
            throw new RuntimeException(e);
        }
        catch (Exception e) {
            logger.error("Unexpected exception occurs at initialize", (Throwable)e);
            throw e;
        }
    }

    public void mountPublicApiHandler(long nodeNativeHandle) {
        try {
            Preconditions.checkState((this.node == null ? 1 : 0) != 0, (String)"There is a node already (%s): are you calling this method twice?", (Object)this.node);
            this.node = new NodeProxy(nodeNativeHandle);
            Router router = this.server.createRouter();
            this.service.createPublicApiHandlers(this.node, router);
            this.server.mountSubRouter(this.serviceApiPath(), router);
        }
        catch (Exception e) {
            logger.error("Unexpected exception occurs at mountPublicApiHandler", (Throwable)e);
            throw e;
        }
    }

    public void afterCommit(long snapshotHandle, int validatorId, long height) {
        assert (snapshotHandle != 0L);
        try (Cleaner cleaner = new Cleaner("UserServiceAdapter#afterCommit");){
            Snapshot snapshot = this.viewFactory.createSnapshot(snapshotHandle, cleaner);
            OptionalInt optionalValidatorId = validatorId >= 0 ? OptionalInt.of(validatorId) : OptionalInt.empty();
            BlockCommittedEventImpl event = BlockCommittedEventImpl.valueOf(snapshot, optionalValidatorId, height);
            this.doAfterCommit(event);
        }
        catch (CloseFailuresException e) {
            logger.error("Failed to close some resources at afterCommit", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    private void doAfterCommit(BlockCommittedEvent event) {
        try {
            this.service.afterCommit(event);
        }
        catch (Exception e) {
            logger.warn("An exception in after commit handler of event {}", (Object)event, (Object)e);
        }
    }

    private String serviceApiPath() {
        String serviceName = this.getName();
        return "/api/services/" + serviceName;
    }

    public void close() {
        try {
            if (this.node != null) {
                this.node.close();
            }
        }
        catch (Exception e) {
            logger.error("Unexpected exception occurs at close", (Throwable)e);
            throw e;
        }
    }
}

