/*
 * Decompiled with CFR 0.152.
 */
package com.exonum.binding.proxy;

import com.google.common.base.Preconditions;
import java.util.Optional;

@FunctionalInterface
public interface CleanAction<ResourceDescriptionT> {
    public void clean();

    default public Optional<ResourceDescriptionT> resourceType() {
        return Optional.empty();
    }

    public static <ResourceDescriptionT> CleanAction<ResourceDescriptionT> from(final Runnable action, final ResourceDescriptionT resourceType) {
        Preconditions.checkNotNull(resourceType, (Object)"resourceType must not be null");
        return new CleanAction<ResourceDescriptionT>(){

            @Override
            public void clean() {
                action.run();
            }

            @Override
            public Optional<ResourceDescriptionT> resourceType() {
                return Optional.of(resourceType);
            }
        };
    }
}

