/*
 * Decompiled with CFR 0.152.
 */
package com.exonum.binding.blockchain;

import com.exonum.binding.blockchain.Block;
import com.exonum.binding.blockchain.serialization.BlockSerializer;
import com.exonum.binding.blockchain.serialization.TransactionLocationSerializer;
import com.exonum.binding.blockchain.serialization.TransactionResultSerializer;
import com.exonum.binding.common.blockchain.TransactionLocation;
import com.exonum.binding.common.blockchain.TransactionResult;
import com.exonum.binding.common.configuration.StoredConfiguration;
import com.exonum.binding.common.hash.HashCode;
import com.exonum.binding.common.message.TransactionMessage;
import com.exonum.binding.common.serialization.Serializer;
import com.exonum.binding.common.serialization.StandardSerializers;
import com.exonum.binding.common.serialization.json.JsonSerializer;
import com.exonum.binding.proxy.Cleaner;
import com.exonum.binding.proxy.NativeHandle;
import com.exonum.binding.proxy.ProxyDestructor;
import com.exonum.binding.storage.database.View;
import com.exonum.binding.storage.indices.KeySetIndexProxy;
import com.exonum.binding.storage.indices.ListIndex;
import com.exonum.binding.storage.indices.ListIndexProxy;
import com.exonum.binding.storage.indices.MapIndex;
import com.exonum.binding.storage.indices.MapIndexProxy;
import com.exonum.binding.storage.indices.ProofListIndexProxy;
import com.exonum.binding.storage.indices.ProofMapIndexProxy;
import com.google.common.base.Preconditions;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

final class CoreSchemaProxy {
    private final NativeHandle nativeHandle;
    private final View dbView;
    private static final Serializer<Block> BLOCK_SERIALIZER = BlockSerializer.INSTANCE;
    private static final Serializer<TransactionLocation> TRANSACTION_LOCATION_SERIALIZER = TransactionLocationSerializer.INSTANCE;
    private static final Serializer<TransactionResult> TRANSACTION_RESULT_SERIALIZER = TransactionResultSerializer.INSTANCE;
    private static final Serializer<TransactionMessage> TRANSACTION_MESSAGE_SERIALIZER = StandardSerializers.transactionMessage();

    private CoreSchemaProxy(NativeHandle nativeHandle, View dbView) {
        this.nativeHandle = nativeHandle;
        this.dbView = dbView;
    }

    static CoreSchemaProxy newInstance(View dbView) {
        long nativePointer = CoreSchemaProxy.nativeCreate(dbView.getViewNativeHandle());
        NativeHandle nativeHandle = new NativeHandle(nativePointer);
        Cleaner cleaner = dbView.getCleaner();
        ProxyDestructor.newRegistered(cleaner, nativeHandle, CoreSchemaProxy.class, CoreSchemaProxy::nativeFree);
        return new CoreSchemaProxy(nativeHandle, dbView);
    }

    long getHeight() {
        return CoreSchemaProxy.nativeGetHeight(this.nativeHandle.get());
    }

    ListIndex<HashCode> getBlockHashes() {
        return ListIndexProxy.newInstance("core.block_hashes_by_height", this.dbView, StandardSerializers.hash());
    }

    ProofListIndexProxy<HashCode> getBlockTransactions(long blockHeight) {
        Preconditions.checkArgument((blockHeight >= 0L ? 1 : 0) != 0, (String)"Height shouldn't be negative, but was %s", (long)blockHeight);
        long blockchainHeight = this.getHeight();
        Preconditions.checkArgument((blockchainHeight >= blockHeight ? 1 : 0) != 0, (String)"Height should be less or equal compared to blockchain height %s, but was %s", (long)blockchainHeight, (long)blockHeight);
        byte[] id = this.toCoreStorageKey(blockHeight);
        return ProofListIndexProxy.newInGroupUnsafe("core.block_transactions", id, this.dbView, StandardSerializers.hash());
    }

    MapIndex<HashCode, Block> getBlocks() {
        return MapIndexProxy.newInstance("core.blocks", this.dbView, StandardSerializers.hash(), BLOCK_SERIALIZER);
    }

    Block getLastBlock() {
        return (Block)BLOCK_SERIALIZER.fromBytes(CoreSchemaProxy.nativeGetLastBlock(this.nativeHandle.get()));
    }

    MapIndex<HashCode, TransactionMessage> getTxMessages() {
        return MapIndexProxy.newInstance("core.transactions", this.dbView, StandardSerializers.hash(), TRANSACTION_MESSAGE_SERIALIZER);
    }

    ProofMapIndexProxy<HashCode, TransactionResult> getTxResults() {
        return ProofMapIndexProxy.newInstance("core.transaction_results", this.dbView, StandardSerializers.hash(), TRANSACTION_RESULT_SERIALIZER);
    }

    MapIndex<HashCode, TransactionLocation> getTxLocations() {
        return MapIndexProxy.newInstance("core.transactions_locations", this.dbView, StandardSerializers.hash(), TRANSACTION_LOCATION_SERIALIZER);
    }

    KeySetIndexProxy<HashCode> getTransactionPool() {
        return KeySetIndexProxy.newInstance("core.transactions_pool", this.dbView, StandardSerializers.hash());
    }

    StoredConfiguration getActualConfiguration() {
        String rawConfiguration = CoreSchemaProxy.nativeGetActualConfiguration(this.nativeHandle.get());
        return (StoredConfiguration)JsonSerializer.json().fromJson(rawConfiguration, StoredConfiguration.class);
    }

    private static native long nativeCreate(long var0);

    private static native void nativeFree(long var0);

    private static native long nativeGetHeight(long var0);

    private static native String nativeGetActualConfiguration(long var0);

    private static native byte[] nativeGetLastBlock(long var0);

    private byte[] toCoreStorageKey(long value) {
        return ByteBuffer.allocate(8).order(ByteOrder.BIG_ENDIAN).putLong(value).array();
    }

    private static final class CoreIndex {
        private static final String PREFIX = "core.";
        private static final String BLOCK_TRANSACTIONS = "core.block_transactions";
        private static final String ALL_BLOCK_HASHES = "core.block_hashes_by_height";
        private static final String TRANSACTIONS = "core.transactions";
        private static final String BLOCKS = "core.blocks";
        private static final String TRANSACTIONS_RESULTS = "core.transaction_results";
        private static final String TRANSACTIONS_LOCATIONS = "core.transactions_locations";
        private static final String TRANSACTIONS_POOL = "core.transactions_pool";

        private CoreIndex() {
        }
    }
}

