/*
 * Decompiled with CFR 0.152.
 */
package com.exonum.binding.blockchain;

import com.exonum.binding.blockchain.Block;
import com.exonum.binding.blockchain.CoreSchemaProxy;
import com.exonum.binding.common.blockchain.TransactionLocation;
import com.exonum.binding.common.blockchain.TransactionResult;
import com.exonum.binding.common.configuration.StoredConfiguration;
import com.exonum.binding.common.hash.HashCode;
import com.exonum.binding.common.message.TransactionMessage;
import com.exonum.binding.storage.database.View;
import com.exonum.binding.storage.indices.KeySetIndexProxy;
import com.exonum.binding.storage.indices.ListIndex;
import com.exonum.binding.storage.indices.MapIndex;
import com.exonum.binding.storage.indices.ProofListIndexProxy;
import com.exonum.binding.storage.indices.ProofMapIndexProxy;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.util.Optional;

public final class Blockchain {
    private final CoreSchemaProxy schema;

    @VisibleForTesting
    Blockchain(CoreSchemaProxy schema) {
        this.schema = schema;
    }

    public static Blockchain newInstance(View view) {
        CoreSchemaProxy coreSchema = CoreSchemaProxy.newInstance(view);
        return new Blockchain(coreSchema);
    }

    public boolean containsBlock(Block block) {
        return this.findBlock(block.getBlockHash()).map(block::equals).orElse(false);
    }

    public long getHeight() {
        return this.schema.getHeight();
    }

    public ListIndex<HashCode> getBlockHashes() {
        return this.schema.getBlockHashes();
    }

    public ProofListIndexProxy<HashCode> getBlockTransactions(long height) {
        return this.schema.getBlockTransactions(height);
    }

    public ProofListIndexProxy<HashCode> getBlockTransactions(HashCode blockId) {
        Optional<Block> block = this.findBlock(blockId);
        Preconditions.checkArgument((boolean)block.isPresent(), (String)"No block found for given id %s", (Object)blockId);
        return this.getBlockTransactions(block.get().getHeight());
    }

    public ProofListIndexProxy<HashCode> getBlockTransactions(Block block) {
        Preconditions.checkArgument((boolean)this.containsBlock(block), (String)"No such block (%s) in the database", (Object)block);
        return this.getBlockTransactions(block.getHeight());
    }

    public MapIndex<HashCode, TransactionMessage> getTxMessages() {
        return this.schema.getTxMessages();
    }

    public ProofMapIndexProxy<HashCode, TransactionResult> getTxResults() {
        return this.schema.getTxResults();
    }

    public Optional<TransactionResult> getTxResult(HashCode messageHash) {
        ProofMapIndexProxy<HashCode, TransactionResult> txResults = this.getTxResults();
        TransactionResult transactionResult = txResults.get(messageHash);
        return Optional.ofNullable(transactionResult);
    }

    public MapIndex<HashCode, TransactionLocation> getTxLocations() {
        return this.schema.getTxLocations();
    }

    public Optional<TransactionLocation> getTxLocation(HashCode messageHash) {
        MapIndex<HashCode, TransactionLocation> txLocations = this.getTxLocations();
        TransactionLocation transactionLocation = txLocations.get(messageHash);
        return Optional.ofNullable(transactionLocation);
    }

    public MapIndex<HashCode, Block> getBlocks() {
        return this.schema.getBlocks();
    }

    public Block getBlock(long height) {
        this.checkHeight(height);
        ListIndex<HashCode> blockHashes = this.getBlockHashes();
        HashCode blockHash = blockHashes.get(height);
        MapIndex<HashCode, Block> blocks = this.getBlocks();
        return blocks.get(blockHash);
    }

    private void checkHeight(long height) {
        long blockchainHeight = this.getHeight();
        if (height < 0L || height > blockchainHeight) {
            throw new IndexOutOfBoundsException("Block height (" + height + ") is out of range [0, " + blockchainHeight + "]");
        }
    }

    public Optional<Block> findBlock(HashCode blockHash) {
        MapIndex<HashCode, Block> blocks = this.getBlocks();
        Block block = blocks.get(blockHash);
        return Optional.ofNullable(block);
    }

    public Block getLastBlock() {
        return this.schema.getLastBlock();
    }

    public StoredConfiguration getActualConfiguration() {
        return this.schema.getActualConfiguration();
    }

    public KeySetIndexProxy<HashCode> getTransactionPool() {
        return this.schema.getTransactionPool();
    }
}

