/*
 * Decompiled with CFR 0.152.
 */
package com.exonum.binding.storage.indices;

import com.exonum.binding.proxy.AbstractNativeProxy;
import com.exonum.binding.proxy.NativeHandle;
import com.exonum.binding.storage.database.ModificationCounter;
import com.exonum.binding.storage.indices.RustIter;
import java.util.ConcurrentModificationException;
import java.util.Optional;
import java.util.function.LongFunction;

final class ConfigurableRustIter<E>
extends AbstractNativeProxy
implements RustIter<E> {
    private final LongFunction<E> nextFunction;
    private final ModificationCounter modificationCounter;
    private final Integer initialModCount;

    ConfigurableRustIter(NativeHandle nativeHandle, LongFunction<E> nextFunction, ModificationCounter modificationCounter) {
        super(nativeHandle);
        this.nextFunction = nextFunction;
        this.modificationCounter = modificationCounter;
        this.initialModCount = modificationCounter.getCurrentValue();
    }

    @Override
    public Optional<E> next() {
        this.checkNotModified();
        return Optional.ofNullable(this.nextFunction.apply(this.getNativeHandle()));
    }

    private void checkNotModified() {
        if (this.modificationCounter.isModifiedSince(this.initialModCount)) {
            throw new ConcurrentModificationException("Collection or the corresponding Fork were modified during iteration");
        }
    }
}

