/*
 * Decompiled with CFR 0.152.
 */
package com.exonum.binding.storage.indices;

import com.exonum.binding.common.serialization.CheckingSerializerDecorator;
import com.exonum.binding.proxy.NativeHandle;
import com.exonum.binding.storage.database.View;
import com.exonum.binding.storage.indices.AbstractIndexProxy;
import com.exonum.binding.storage.indices.ListIndex;
import com.exonum.binding.storage.indices.ListSpliterator;
import com.exonum.binding.storage.indices.StorageIterators;
import com.exonum.binding.storage.indices.StoragePreconditions;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

abstract class AbstractListIndexProxy<T>
extends AbstractIndexProxy
implements ListIndex<T> {
    final CheckingSerializerDecorator<T> serializer;

    AbstractListIndexProxy(NativeHandle nativeHandle, String name, View view, CheckingSerializerDecorator<T> userSerializer) {
        super(nativeHandle, name, view);
        this.serializer = userSerializer;
    }

    @Override
    public final void add(T e) {
        this.notifyModified();
        byte[] dbElement = this.serializer.toBytes(e);
        this.nativeAdd(this.getNativeHandle(), dbElement);
    }

    @Override
    public void addAll(Collection<? extends T> elements) {
        this.notifyModified();
        StoragePreconditions.checkNoNulls(elements);
        this.addAllUnchecked(elements);
    }

    private void addAllUnchecked(Collection<? extends T> elements) {
        long nativeHandle = this.getNativeHandle();
        elements.stream().map(arg_0 -> this.serializer.toBytes(arg_0)).forEach(e -> this.nativeAdd(nativeHandle, (byte[])e));
    }

    @Override
    public final void set(long index, T e) {
        StoragePreconditions.checkElementIndex(index, this.size());
        this.notifyModified();
        byte[] dbElement = this.serializer.toBytes(e);
        this.nativeSet(this.getNativeHandle(), index, dbElement);
    }

    @Override
    public final T get(long index) {
        StoragePreconditions.checkElementIndex(index, this.size());
        byte[] e = this.nativeGet(this.getNativeHandle(), index);
        return (T)this.serializer.fromBytes(e);
    }

    @Override
    public final T getLast() {
        byte[] e = this.nativeGetLast(this.getNativeHandle());
        if (e == null) {
            throw new NoSuchElementException("List is empty");
        }
        return (T)this.serializer.fromBytes(e);
    }

    @Override
    public final void clear() {
        this.notifyModified();
        this.nativeClear(this.getNativeHandle());
    }

    @Override
    public final boolean isEmpty() {
        return this.nativeIsEmpty(this.getNativeHandle());
    }

    @Override
    public final long size() {
        return this.nativeSize(this.getNativeHandle());
    }

    @Override
    public final Iterator<T> iterator() {
        return StorageIterators.createIterator(this.nativeCreateIter(this.getNativeHandle()), this::nativeIterNext, this::nativeIterFree, this.dbView, this.modCounter, arg_0 -> this.serializer.fromBytes(arg_0));
    }

    @Override
    public Stream<T> stream() {
        boolean immutable = !this.dbView.canModify();
        ListSpliterator spliterator = new ListSpliterator(this, this.modCounter, immutable);
        return StreamSupport.stream(spliterator, false);
    }

    abstract void nativeAdd(long var1, byte[] var3);

    abstract void nativeSet(long var1, long var3, byte[] var5);

    abstract byte[] nativeGet(long var1, long var3);

    abstract byte[] nativeGetLast(long var1);

    abstract void nativeClear(long var1);

    abstract boolean nativeIsEmpty(long var1);

    abstract long nativeSize(long var1);

    abstract long nativeCreateIter(long var1);

    abstract byte[] nativeIterNext(long var1);

    abstract void nativeIterFree(long var1);
}

