/*
 * Decompiled with CFR 0.152.
 */
package com.exonum.binding.runtime;

import com.exonum.binding.service.adapters.UserServiceAdapter;
import com.exonum.binding.transport.Server;
import com.google.common.base.Preconditions;
import com.google.inject.Injector;
import com.google.inject.Module;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;

final class ServiceRuntime {
    private final Injector frameworkInjector;

    ServiceRuntime(Injector frameworkInjector, int serverPort) {
        this.frameworkInjector = (Injector)Preconditions.checkNotNull((Object)frameworkInjector);
        this.checkServerIsSingleton(frameworkInjector);
        Server server = (Server)frameworkInjector.getInstance(Server.class);
        server.start(serverPort);
    }

    private void checkServerIsSingleton(Injector frameworkInjector) {
        Server s1 = (Server)frameworkInjector.getInstance(Server.class);
        Server s2 = (Server)frameworkInjector.getInstance(Server.class);
        Preconditions.checkArgument((boolean)s1.equals(s2), (String)"%s is not configured as singleton: s1=%s, s2=%s", Server.class, (Object)s1, (Object)s2);
    }

    String loadArtifact(String serviceArtifactPath) {
        return "com.acme:any-service:1.0.0";
    }

    UserServiceAdapter createService(String artifactId, String moduleName) {
        Module serviceModule = ServiceRuntime.createUserModule(moduleName);
        Injector serviceInjector = this.frameworkInjector.createChildInjector(new Module[]{serviceModule});
        return (UserServiceAdapter)serviceInjector.getInstance(UserServiceAdapter.class);
    }

    private static Module createUserModule(String moduleName) {
        try {
            Class<?> moduleClass = Class.forName(moduleName);
            Constructor<?> constructor = moduleClass.getDeclaredConstructor(new Class[0]);
            Object moduleObject = constructor.newInstance(new Object[0]);
            Preconditions.checkArgument((boolean)(moduleObject instanceof Module), (String)"%s is not a sub-class of %s", moduleClass, (Object)Module.class.getCanonicalName());
            return (Module)moduleObject;
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException("Module class cannot be found", e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException("Cannot access the no-arg module constructor", e);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException("No no-arg constructor", e);
        }
        catch (InstantiationException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }
}

