/*
 * Decompiled with CFR 0.152.
 */
package com.exonum.binding.runtime;

import com.exonum.binding.service.ServiceModule;
import com.google.common.base.MoreObjects;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.function.Supplier;

final class ReflectiveModuleSupplier
implements Supplier<ServiceModule> {
    private final Class<? extends ServiceModule> moduleClass;
    private final MethodHandle moduleConstructor;

    ReflectiveModuleSupplier(Class<? extends ServiceModule> moduleClass) throws NoSuchMethodException, IllegalAccessException {
        this.moduleClass = moduleClass;
        MethodHandles.Lookup lookup = MethodHandles.lookup();
        MethodType mt = MethodType.methodType(Void.TYPE);
        this.moduleConstructor = lookup.findConstructor(moduleClass, mt);
    }

    @Override
    public ServiceModule get() {
        return this.newServiceModule();
    }

    private ServiceModule newServiceModule() {
        try {
            return this.moduleConstructor.invoke();
        }
        catch (Throwable throwable) {
            String message = String.format("Cannot instantiate a service module of class %s using constructor %s", this.moduleClass, this.moduleConstructor);
            throw new IllegalStateException(message, throwable);
        }
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("moduleClass", this.moduleClass).add("moduleConstructor", (Object)this.moduleConstructor).toString();
    }
}

