/*
 * Decompiled with CFR 0.152.
 */
package com.exonum.binding.runtime;

import com.exonum.binding.runtime.LoadedServiceDefinition;
import com.exonum.binding.runtime.ReflectiveModuleSupplier;
import com.exonum.binding.runtime.ServiceId;
import com.exonum.binding.runtime.ServiceLoader;
import com.exonum.binding.runtime.ServiceLoadingException;
import com.exonum.binding.service.ServiceModule;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.inject.Inject;
import java.nio.file.Path;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.function.Supplier;
import org.pf4j.Extension;
import org.pf4j.PluginManager;
import org.pf4j.PluginState;

final class Pf4jServiceLoader
implements ServiceLoader {
    private static final Comparator<ServiceId> SERVICE_ID_COMPARATOR = Comparator.comparing(ServiceId::getGroupId).thenComparing(ServiceId::getArtifactId).thenComparing(ServiceId::getVersion);
    private final PluginManager pluginManager;
    private final SortedMap<ServiceId, LoadedServiceDefinition> loadedServices;

    @Inject
    Pf4jServiceLoader(PluginManager pluginManager) {
        this.pluginManager = (PluginManager)Preconditions.checkNotNull((Object)pluginManager);
        this.loadedServices = new TreeMap<ServiceId, LoadedServiceDefinition>(SERVICE_ID_COMPARATOR);
    }

    @Override
    public LoadedServiceDefinition loadService(Path artifactPath) throws ServiceLoadingException {
        String pluginId = this.loadPlugin(artifactPath);
        try {
            this.startPlugin(pluginId);
            return this.loadDefinition(pluginId);
        }
        catch (IllegalArgumentException e) {
            this.pluginManager.unloadPlugin(pluginId);
            throw new ServiceLoadingException(String.format("Failed to load plugin %s:", pluginId), e);
        }
        catch (Exception e) {
            this.pluginManager.unloadPlugin(pluginId);
            throw e;
        }
    }

    private String loadPlugin(Path artifactLocation) throws ServiceLoadingException {
        String pluginId = this.pluginManager.loadPlugin(artifactLocation);
        if (pluginId == null) {
            throw new ServiceLoadingException("Failed to load the plugin from " + artifactLocation);
        }
        return pluginId;
    }

    private void startPlugin(String pluginId) throws ServiceLoadingException {
        PluginState pluginState = this.pluginManager.startPlugin(pluginId);
        if (pluginState != PluginState.STARTED) {
            throw new ServiceLoadingException(String.format("Failed to start the plugin %s, its state=%s", pluginId, pluginState));
        }
    }

    private LoadedServiceDefinition loadDefinition(String pluginId) throws ServiceLoadingException {
        ServiceId serviceId = Pf4jServiceLoader.extractServiceId(pluginId);
        Supplier<ServiceModule> serviceModuleSupplier = this.findServiceModuleSupplier(pluginId);
        LoadedServiceDefinition serviceDefinition = LoadedServiceDefinition.newInstance(serviceId, serviceModuleSupplier);
        assert (!this.loadedServices.containsKey(serviceId));
        this.loadedServices.put(serviceId, serviceDefinition);
        return serviceDefinition;
    }

    private static ServiceId extractServiceId(String pluginId) throws ServiceLoadingException {
        try {
            return ServiceId.parseFrom(pluginId);
        }
        catch (IllegalArgumentException e) {
            throw new ServiceLoadingException(String.format("Invalid plugin id (%s) is specified in service artifact metadata, must be in format 'groupId:artifactId:version'", pluginId));
        }
    }

    private Supplier<ServiceModule> findServiceModuleSupplier(String pluginId) throws ServiceLoadingException {
        List extensionClasses = this.pluginManager.getExtensionClasses(ServiceModule.class, pluginId);
        this.checkServiceModules(pluginId, extensionClasses);
        Class serviceModuleClass = (Class)extensionClasses.get(0);
        try {
            return new ReflectiveModuleSupplier(serviceModuleClass);
        }
        catch (IllegalAccessException | NoSuchMethodException e) {
            String message = String.format("Cannot load a plugin (%s): module (%s) is not valid", pluginId, serviceModuleClass);
            throw new ServiceLoadingException(message, e);
        }
    }

    private void checkServiceModules(String pluginId, List<Class<ServiceModule>> extensions) throws ServiceLoadingException {
        int numServiceModules = extensions.size();
        if (numServiceModules == 1) {
            return;
        }
        String message = numServiceModules == 0 ? String.format("A plugin (%s) must provide exactly one service module as an extension, but no modules found.%nCheck that your %s implementation is annotated with @%s", pluginId, ServiceModule.class.getSimpleName(), Extension.class.getSimpleName()) : String.format("A plugin (%s) must provide exactly one service module as an extension, but %d modules found:%n%s.%nMultiple modules are not currently supported, but please let us know if you need them.", pluginId, numServiceModules, extensions);
        throw new ServiceLoadingException(message);
    }

    @Override
    public Optional<LoadedServiceDefinition> findService(ServiceId serviceId) {
        return Optional.ofNullable(this.loadedServices.get(serviceId));
    }

    @Override
    public void unloadService(ServiceId serviceId) {
        Preconditions.checkArgument((boolean)this.loadedServices.containsKey(serviceId), (String)"No such serviceId: %s", (Object)serviceId);
        String pluginId = serviceId.toString();
        boolean stopped = this.pluginManager.unloadPlugin(pluginId);
        Preconditions.checkState((boolean)stopped, (String)"Unknown error whilst unloading the plugin (%s)", (Object)pluginId);
        this.loadedServices.remove(serviceId);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("loadedServices", this.loadedServices).toString();
    }
}

