/*
 * Decompiled with CFR 0.152.
 */
package com.exonum.binding.blockchain.serialization;

import com.exonum.binding.blockchain.serialization.CoreProtos;
import com.exonum.binding.common.blockchain.TransactionLocation;
import com.exonum.binding.common.serialization.Serializer;
import com.exonum.binding.common.serialization.StandardSerializers;

public enum TransactionLocationSerializer implements Serializer<TransactionLocation>
{
    INSTANCE;

    private static final Serializer<CoreProtos.TxLocation> PROTO_SERIALIZER;

    public byte[] toBytes(TransactionLocation value) {
        CoreProtos.TxLocation txLocation = CoreProtos.TxLocation.newBuilder().setBlockHeight(value.getHeight()).setPositionInBlock(value.getIndexInBlock()).build();
        return txLocation.toByteArray();
    }

    public TransactionLocation fromBytes(byte[] binaryTransactionLocation) {
        CoreProtos.TxLocation copiedtxLocationProtos = (CoreProtos.TxLocation)PROTO_SERIALIZER.fromBytes(binaryTransactionLocation);
        return TransactionLocation.valueOf((long)copiedtxLocationProtos.getBlockHeight(), (long)copiedtxLocationProtos.getPositionInBlock());
    }

    static {
        PROTO_SERIALIZER = StandardSerializers.protobuf(CoreProtos.TxLocation.class);
    }
}

