/*
 * Decompiled with CFR 0.152.
 */
package com.exonum.binding.storage.indices;

import com.exonum.binding.proxy.Cleaner;
import com.exonum.binding.proxy.NativeHandle;
import com.exonum.binding.proxy.ProxyDestructor;
import com.exonum.binding.storage.database.ModificationCounter;
import com.exonum.binding.storage.database.View;
import com.exonum.binding.storage.indices.ConfigurableRustIter;
import com.exonum.binding.storage.indices.RustIter;
import com.exonum.binding.storage.indices.RustIterAdapter;
import com.google.common.collect.Iterators;
import java.util.Iterator;
import java.util.function.Function;
import java.util.function.LongConsumer;
import java.util.function.LongFunction;

final class StorageIterators {
    static <ElementT, NativeT> Iterator<ElementT> createIterator(long nativeHandle, LongFunction<NativeT> nextFunction, LongConsumer disposeOperation, View collectionView, ModificationCounter modificationCounter, Function<? super NativeT, ? extends ElementT> transformingFunction) {
        NativeHandle handle = new NativeHandle(nativeHandle);
        Cleaner cleaner = collectionView.getCleaner();
        cleaner.add(new ProxyDestructor(handle, RustIter.class, disposeOperation));
        RustIterAdapter<NativeT> iterator = new RustIterAdapter<NativeT>(new ConfigurableRustIter<NativeT>(handle, nextFunction, modificationCounter));
        return Iterators.transform(iterator, transformingFunction::apply);
    }

    private StorageIterators() {
    }
}

