/*
 * Decompiled with CFR 0.152.
 */
package com.exonum.binding.storage.indices;

import com.exonum.binding.common.hash.HashCode;
import com.exonum.binding.common.proofs.list.ListProofNode;
import com.exonum.binding.common.proofs.list.UncheckedListProof;
import com.exonum.binding.common.proofs.list.UncheckedListProofAdapter;
import com.exonum.binding.common.serialization.CheckingSerializerDecorator;
import com.exonum.binding.common.serialization.Serializer;
import com.exonum.binding.common.serialization.StandardSerializers;
import com.exonum.binding.proxy.Cleaner;
import com.exonum.binding.proxy.NativeHandle;
import com.exonum.binding.proxy.ProxyDestructor;
import com.exonum.binding.storage.database.View;
import com.exonum.binding.storage.indices.AbstractListIndexProxy;
import com.exonum.binding.storage.indices.ListIndex;
import com.exonum.binding.storage.indices.StoragePreconditions;
import com.google.protobuf.MessageLite;
import java.util.function.LongSupplier;

public final class ProofListIndexProxy<E>
extends AbstractListIndexProxy<E>
implements ListIndex<E> {
    public static <E extends MessageLite> ProofListIndexProxy<E> newInstance(String name, View view, Class<E> elementType) {
        return ProofListIndexProxy.newInstance(name, view, StandardSerializers.protobuf(elementType));
    }

    public static <E> ProofListIndexProxy<E> newInstance(String name, View view, Serializer<E> serializer) {
        StoragePreconditions.checkIndexName(name);
        CheckingSerializerDecorator s = CheckingSerializerDecorator.from(serializer);
        long viewNativeHandle = view.getViewNativeHandle();
        NativeHandle listNativeHandle = ProofListIndexProxy.createNativeList(view, () -> ProofListIndexProxy.nativeCreate(name, viewNativeHandle));
        return new ProofListIndexProxy<E>(listNativeHandle, name, view, s);
    }

    private static native long nativeCreate(String var0, long var1);

    public static <E> ProofListIndexProxy<E> newInGroupUnsafe(String groupName, byte[] listId, View view, Serializer<E> serializer) {
        StoragePreconditions.checkIndexName(groupName);
        StoragePreconditions.checkIdInGroup(listId);
        CheckingSerializerDecorator s = CheckingSerializerDecorator.from(serializer);
        long viewNativeHandle = view.getViewNativeHandle();
        NativeHandle setNativeHandle = ProofListIndexProxy.createNativeList(view, () -> ProofListIndexProxy.nativeCreateInGroup(groupName, listId, viewNativeHandle));
        return new ProofListIndexProxy<E>(setNativeHandle, groupName, view, s);
    }

    private static native long nativeCreateInGroup(String var0, byte[] var1, long var2);

    private static NativeHandle createNativeList(View view, LongSupplier nativeListConstructor) {
        NativeHandle listNativeHandle = new NativeHandle(nativeListConstructor.getAsLong());
        Cleaner cleaner = view.getCleaner();
        ProxyDestructor.newRegistered(cleaner, listNativeHandle, ProofListIndexProxy.class, ProofListIndexProxy::nativeFree);
        return listNativeHandle;
    }

    private ProofListIndexProxy(NativeHandle nativeHandle, String name, View view, CheckingSerializerDecorator<E> serializer) {
        super(nativeHandle, name, view, serializer);
    }

    public UncheckedListProof getProof(long index) {
        StoragePreconditions.checkElementIndex(index, this.size());
        ListProofNode listProofNode = this.nativeGetProof(this.getNativeHandle(), index);
        return new UncheckedListProofAdapter(listProofNode, (Serializer)this.serializer);
    }

    private native ListProofNode nativeGetProof(long var1, long var3);

    public UncheckedListProof getRangeProof(long from, long to) {
        long size = this.size();
        ListProofNode listProofNode = this.nativeGetRangeProof(this.getNativeHandle(), StoragePreconditions.checkElementIndex(from, size), StoragePreconditions.checkPositionIndex(to, size));
        return new UncheckedListProofAdapter(listProofNode, (Serializer)this.serializer);
    }

    private native ListProofNode nativeGetRangeProof(long var1, long var3, long var5);

    public HashCode getRootHash() {
        return HashCode.fromBytes((byte[])this.nativeGetRootHash(this.getNativeHandle()));
    }

    private native byte[] nativeGetRootHash(long var1);

    private static native void nativeFree(long var0);

    @Override
    native void nativeAdd(long var1, byte[] var3);

    @Override
    native void nativeSet(long var1, long var3, byte[] var5);

    @Override
    native byte[] nativeGet(long var1, long var3);

    @Override
    native byte[] nativeGetLast(long var1);

    @Override
    native void nativeClear(long var1);

    @Override
    native boolean nativeIsEmpty(long var1);

    @Override
    native long nativeSize(long var1);

    @Override
    native long nativeCreateIter(long var1);

    @Override
    native byte[] nativeIterNext(long var1);

    @Override
    native void nativeIterFree(long var1);
}

