/*
 * Decompiled with CFR 0.152.
 */
package com.exonum.binding.storage.database;

import com.exonum.binding.proxy.Cleaner;
import com.exonum.binding.proxy.NativeHandle;
import com.exonum.binding.proxy.ProxyDestructor;
import com.exonum.binding.storage.database.ImmutableModificationCounter;
import com.exonum.binding.storage.database.View;
import com.exonum.binding.storage.database.Views;
import com.google.common.base.Preconditions;

public final class Snapshot
extends View {
    public static Snapshot newInstance(long nativeHandle, Cleaner cleaner) {
        return Snapshot.newInstance(nativeHandle, true, cleaner);
    }

    public static Snapshot newInstance(long nativeHandle, boolean owningHandle, Cleaner cleaner) {
        Preconditions.checkNotNull((Object)cleaner, (Object)"cleaner");
        NativeHandle h = new NativeHandle(nativeHandle);
        ProxyDestructor.newRegistered(cleaner, h, Snapshot.class, nh -> {
            if (owningHandle) {
                Views.nativeFree(nh);
            }
        });
        return new Snapshot(h, cleaner);
    }

    private Snapshot(NativeHandle nativeHandle, Cleaner cleaner) {
        super(nativeHandle, cleaner, ImmutableModificationCounter.INSTANCE, false);
    }
}

