/*
 * Decompiled with CFR 0.152.
 */
package com.exonum.binding.service;

import com.exonum.binding.common.crypto.PublicKey;
import com.exonum.binding.common.hash.HashCode;
import com.exonum.binding.proxy.AbstractCloseableNativeProxy;
import com.exonum.binding.proxy.Cleaner;
import com.exonum.binding.proxy.CloseFailuresException;
import com.exonum.binding.service.InternalServerError;
import com.exonum.binding.service.Node;
import com.exonum.binding.storage.database.Snapshot;
import com.exonum.binding.transaction.RawTransaction;
import java.util.function.Function;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class NodeProxy
extends AbstractCloseableNativeProxy
implements Node {
    private static final Logger logger = LogManager.getLogger(NodeProxy.class);

    public NodeProxy(long nativeHandle) {
        super(nativeHandle, false);
    }

    @Override
    public HashCode submitTransaction(RawTransaction rawTransaction) throws InternalServerError {
        byte[] payload = rawTransaction.getPayload();
        short serviceId = rawTransaction.getServiceId();
        short transactionId = rawTransaction.getTransactionId();
        byte[] txMessageHash = NodeProxy.nativeSubmit(this.getNativeHandle(), payload, serviceId, transactionId);
        return HashCode.fromBytes((byte[])txMessageHash);
    }

    private static native byte[] nativeSubmit(long var0, byte[] var2, short var3, short var4) throws InternalServerError;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public <ResultT> ResultT withSnapshot(Function<Snapshot, ResultT> snapshotFunction) {
        try (Cleaner cleaner = new Cleaner("NodeProxy#withSnapshot");){
            long nodeNativeHandle = this.getNativeHandle();
            long snapshotNativeHandle = this.nativeCreateSnapshot(nodeNativeHandle);
            Snapshot snapshot = Snapshot.newInstance(snapshotNativeHandle, cleaner);
            ResultT ResultT = snapshotFunction.apply(snapshot);
            return ResultT;
        }
        catch (CloseFailuresException e) {
            logger.error((Object)e);
            throw new RuntimeException(e);
        }
    }

    private native long nativeCreateSnapshot(long var1);

    @Override
    public PublicKey getPublicKey() {
        byte[] publicKey = this.nativeGetPublicKey(this.getNativeHandle());
        return PublicKey.fromBytes((byte[])publicKey);
    }

    private native byte[] nativeGetPublicKey(long var1);

    @Override
    protected void disposeInternal() {
        NodeProxy.nativeFree(this.getNativeHandle());
    }

    private static native void nativeFree(long var0);
}

